/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.Service;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.remote.request.AbstractNamingRequest;
import com.alibaba.nacos.api.naming.remote.request.InstanceRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceListRequest;
import com.alibaba.nacos.api.naming.remote.request.ServiceQueryRequest;
import com.alibaba.nacos.api.naming.remote.request.SubscribeServiceRequest;
import com.alibaba.nacos.api.naming.remote.response.QueryServiceResponse;
import com.alibaba.nacos.api.naming.remote.response.ServiceListResponse;
import com.alibaba.nacos.api.naming.remote.response.SubscribeServiceResponse;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.api.selector.AbstractSelector;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.naming.remote.AbstractNamingClientProxy;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcConnectionEventListener;
import com.alibaba.nacos.client.naming.remote.gprc.NamingPushRequestHandler;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientFactory;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class NamingGrpcClientProxy
extends AbstractNamingClientProxy {
    private final String namespaceId;
    private final String uuid;
    private final Long requestTimeout;
    private final RpcClient rpcClient;
    private final NamingGrpcConnectionEventListener namingGrpcConnectionEventListener;

    public NamingGrpcClientProxy(String namespaceId, SecurityProxy securityProxy, ServerListFactory serverListFactory, Properties properties, ServiceInfoHolder serviceInfoHolder) throws NacosException {
        super(securityProxy, properties);
        this.namespaceId = namespaceId;
        this.uuid = UUID.randomUUID().toString();
        this.requestTimeout = Long.parseLong(properties.getProperty("namingRequestTimeout", "-1"));
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("source", "sdk");
        labels.put("module", "naming");
        this.rpcClient = RpcClientFactory.createClient(this.uuid, ConnectionType.GRPC, labels);
        this.namingGrpcConnectionEventListener = new NamingGrpcConnectionEventListener(this);
        this.start(serverListFactory, serviceInfoHolder);
    }

    private void start(ServerListFactory serverListFactory, ServiceInfoHolder serviceInfoHolder) throws NacosException {
        this.rpcClient.serverListFactory(serverListFactory);
        this.rpcClient.start();
        this.rpcClient.registerServerRequestHandler(new NamingPushRequestHandler(serviceInfoHolder));
        this.rpcClient.registerConnectionListener(this.namingGrpcConnectionEventListener);
    }

    @Override
    public void registerService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[REGISTER-SERVICE] {} registering service {} with instance {}", new Object[]{this.namespaceId, serviceName, instance});
        InstanceRequest request = new InstanceRequest(this.namespaceId, serviceName, groupName, "registerInstance", instance);
        this.requestToServer(request, Response.class);
        this.namingGrpcConnectionEventListener.cacheInstanceForRedo(serviceName, groupName, instance);
    }

    @Override
    public void deregisterService(String serviceName, String groupName, Instance instance) throws NacosException {
        LogUtils.NAMING_LOGGER.info("[DEREGISTER-SERVICE] {} deregistering service {} with instance: {}", new Object[]{this.namespaceId, serviceName, instance});
        InstanceRequest request = new InstanceRequest(this.namespaceId, serviceName, groupName, "deregisterInstance", instance);
        this.requestToServer(request, Response.class);
        this.namingGrpcConnectionEventListener.removeInstanceForRedo(serviceName, groupName, instance);
    }

    @Override
    public void updateInstance(String serviceName, String groupName, Instance instance) throws NacosException {
    }

    @Override
    public ServiceInfo queryInstancesOfService(String serviceName, String groupName, String clusters, int udpPort, boolean healthyOnly) throws NacosException {
        ServiceQueryRequest request = new ServiceQueryRequest(this.namespaceId, serviceName, groupName);
        request.setCluster(clusters);
        request.setHealthyOnly(healthyOnly);
        request.setUdpPort(udpPort);
        QueryServiceResponse response = this.requestToServer(request, QueryServiceResponse.class);
        return response.getServiceInfo();
    }

    @Override
    public Service queryService(String serviceName, String groupName) throws NacosException {
        return null;
    }

    @Override
    public void createService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public boolean deleteService(String serviceName, String groupName) throws NacosException {
        return false;
    }

    @Override
    public void updateService(Service service, AbstractSelector selector) throws NacosException {
    }

    @Override
    public ListView<String> getServiceList(int pageNo, int pageSize, String groupName, AbstractSelector selector) throws NacosException {
        ServiceListRequest request = new ServiceListRequest(this.namespaceId, groupName, pageNo, pageSize);
        if (selector != null && SelectorType.valueOf(selector.getType()) == SelectorType.label) {
            request.setSelector(JacksonUtils.toJson(selector));
        }
        ServiceListResponse response = this.requestToServer(request, ServiceListResponse.class);
        ListView<String> result = new ListView<String>();
        result.setCount(response.getCount());
        result.setData(response.getServiceNames());
        return result;
    }

    @Override
    public ServiceInfo subscribe(String serviceName, String groupName, String clusters) throws NacosException {
        SubscribeServiceRequest request = new SubscribeServiceRequest(this.namespaceId, groupName, serviceName, clusters, true);
        SubscribeServiceResponse response = this.requestToServer(request, SubscribeServiceResponse.class);
        this.namingGrpcConnectionEventListener.cacheSubscriberForRedo(NamingUtils.getGroupedName(serviceName, groupName), clusters);
        return response.getServiceInfo();
    }

    @Override
    public void unsubscribe(String serviceName, String groupName, String clusters) throws NacosException {
        SubscribeServiceRequest request = new SubscribeServiceRequest(this.namespaceId, serviceName, groupName, clusters, false);
        this.requestToServer(request, SubscribeServiceResponse.class);
        this.namingGrpcConnectionEventListener.removeSubscriberForRedo(NamingUtils.getGroupedName(serviceName, groupName), clusters);
    }

    @Override
    public void updateBeatInfo(Set<Instance> modifiedInstances) {
    }

    @Override
    public boolean serverHealthy() {
        return this.rpcClient.isRunning();
    }

    private <T extends Response> T requestToServer(AbstractNamingRequest request, Class<T> responseClass) throws NacosException {
        try {
            Response response;
            request.putAllHeader(this.getSecurityHeaders());
            request.putAllHeader(this.getSpasHeaders(NamingUtils.getGroupedNameOptional(request.getServiceName(), request.getGroupName())));
            Response response2 = response = this.requestTimeout < 0L ? this.rpcClient.request(request) : this.rpcClient.request(request, this.requestTimeout);
            if (ResponseCode.SUCCESS.getCode() != response.getResultCode()) {
                throw new NacosException(response.getErrorCode(), response.getMessage());
            }
            if (responseClass.isAssignableFrom(response.getClass())) {
                return (T)response;
            }
            LogUtils.NAMING_LOGGER.error("Server return unexpected response '{}', expected response should be '{}'", (Object)response.getClass().getName(), (Object)responseClass.getName());
        }
        catch (Exception e) {
            throw new NacosException(500, "Request nacos server failed: ", e);
        }
        throw new NacosException(500, "Server return invalid response");
    }

    @Override
    public void shutdown() throws NacosException {
        this.rpcClient.shutdown();
    }

    public boolean isEnable() {
        return this.rpcClient.isRunning();
    }
}

