/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import com.alibaba.nacos.client.logging.AbstractNacosLogging;
import com.alibaba.nacos.common.utils.ResourceUtils;
import com.alibaba.nacos.common.utils.StringUtils;

public class LogbackNacosLogging
extends AbstractNacosLogging {
    private static final String NACOS_LOGBACK_LOCATION = "classpath:nacos-logback.xml";
    private static LoggerContext loggerContext;

    public static LoggerContext getLoggerContext() {
        return loggerContext;
    }

    @Override
    public void loadConfiguration() {
        String location = this.getLocation(NACOS_LOGBACK_LOCATION);
        if (StringUtils.isBlank(location)) {
            return;
        }
        try {
            loggerContext = new LoggerContext();
            new ContextInitializer(loggerContext).configureByResource(ResourceUtils.getResourceUrl(location));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize Logback Nacos logging from " + location, e);
        }
    }
}

