/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.epoll;

import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.ChannelOutboundBuffer;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.socket.DatagramPacket;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.unix.IovArray;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.unix.Limits;
import com.alibaba.nacos.shaded.io.grpc.netty.shaded.io.netty.channel.unix.NativeInetAddress;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

final class NativeDatagramPacketArray
implements ChannelOutboundBuffer.MessageProcessor {
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private final IovArray iovArray = new IovArray();
    private int count;

    NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket();
        }
    }

    boolean add(DatagramPacket packet) {
        if (this.count == this.packets.length) {
            return false;
        }
        ByteBuf content = (ByteBuf)packet.content();
        int len = content.readableBytes();
        if (len == 0) {
            return true;
        }
        NativeDatagramPacket p = this.packets[this.count];
        InetSocketAddress recipient = (InetSocketAddress)packet.recipient();
        int offset = this.iovArray.count();
        if (!this.iovArray.add(content)) {
            return false;
        }
        p.init(this.iovArray.memoryAddress(offset), this.iovArray.count() - offset, recipient);
        ++this.count;
        return true;
    }

    @Override
    public boolean processMessage(Object msg) {
        return msg instanceof DatagramPacket && this.add((DatagramPacket)msg);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacket[] packets() {
        return this.packets;
    }

    void clear() {
        this.count = 0;
        this.iovArray.clear();
    }

    void release() {
        this.iovArray.release();
    }

    static final class NativeDatagramPacket {
        private long memoryAddress;
        private int count;
        private byte[] addr;
        private int scopeId;
        private int port;

        NativeDatagramPacket() {
        }

        private void init(long memoryAddress, int count, InetSocketAddress recipient) {
            this.memoryAddress = memoryAddress;
            this.count = count;
            InetAddress address = recipient.getAddress();
            if (address instanceof Inet6Address) {
                this.addr = address.getAddress();
                this.scopeId = ((Inet6Address)address).getScopeId();
            } else {
                this.addr = NativeInetAddress.ipv4MappedIpv6Address(address.getAddress());
                this.scopeId = 0;
            }
            this.port = recipient.getPort();
        }
    }
}

