/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.store.helper;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.alibaba.otter.canal.store.model.Event;
import org.apache.commons.lang.StringUtils;

public class CanalEventUtils {
    public static LogPosition min(LogPosition position1, LogPosition position2) {
        if (position1.getIdentity().equals((Object)position2.getIdentity())) {
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) > 0) {
                return position2;
            }
            if (position1.getPostion().getJournalName().compareTo(position2.getPostion().getJournalName()) < 0) {
                return position1;
            }
            if (position1.getPostion().getPosition() > position2.getPostion().getPosition()) {
                return position2;
            }
            return position1;
        }
        if (position1.getPostion().getTimestamp() > position2.getPostion().getTimestamp()) {
            return position2;
        }
        return position1;
    }

    public static LogPosition createPosition(Event event) {
        EntryPosition position = new EntryPosition();
        position.setJournalName(event.getEntry().getHeader().getLogfileName());
        position.setPosition(Long.valueOf(event.getEntry().getHeader().getLogfileOffset()));
        position.setTimestamp(Long.valueOf(event.getEntry().getHeader().getExecuteTime()));
        position.setServerId(Long.valueOf(event.getEntry().getHeader().getServerId()));
        LogPosition logPosition = new LogPosition();
        logPosition.setPostion(position);
        logPosition.setIdentity(event.getLogIdentity());
        return logPosition;
    }

    public static LogPosition createPosition(Event event, boolean included) {
        EntryPosition position = new EntryPosition();
        position.setJournalName(event.getEntry().getHeader().getLogfileName());
        position.setPosition(Long.valueOf(event.getEntry().getHeader().getLogfileOffset()));
        position.setTimestamp(Long.valueOf(event.getEntry().getHeader().getExecuteTime()));
        position.setIncluded(included);
        LogPosition logPosition = new LogPosition();
        logPosition.setPostion(position);
        logPosition.setIdentity(event.getLogIdentity());
        return logPosition;
    }

    public static boolean checkPosition(Event event, LogPosition logPosition) {
        boolean exactely;
        EntryPosition position = logPosition.getPostion();
        CanalEntry.Entry entry = event.getEntry();
        boolean result = position.getTimestamp().equals(entry.getHeader().getExecuteTime());
        boolean bl = exactely = StringUtils.isBlank((String)position.getJournalName()) && position.getPosition() == null;
        if (!exactely) {
            result &= StringUtils.equals((String)entry.getHeader().getLogfileName(), (String)position.getJournalName());
            result &= position.getPosition().equals(entry.getHeader().getLogfileOffset());
        }
        return result;
    }
}

