/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.anno.support.AbstractLifecycle;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.CacheMonitorManager;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultCacheMonitorManager;
import com.alicp.jetcache.anno.support.DefaultCacheNameGenerator;
import com.alicp.jetcache.anno.support.DefaultEncoderParser;
import com.alicp.jetcache.anno.support.DefaultKeyConvertorParser;
import com.alicp.jetcache.anno.support.EncoderParser;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.KeyConvertorParser;
import com.alicp.jetcache.anno.support.SimpleCacheManager;
import com.alicp.jetcache.support.CacheMessagePublisher;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;

public class ConfigProvider
extends AbstractLifecycle {
    @Resource
    protected GlobalCacheConfig globalCacheConfig;
    protected SimpleCacheManager cacheManager;
    protected EncoderParser encoderParser;
    protected KeyConvertorParser keyConvertorParser;
    protected CacheMonitorManager cacheMonitorManager;
    private Consumer<StatInfo> metricsCallback = new StatInfoLogger(false);
    private CacheMessagePublisher cacheMessagePublisher;
    private CacheMonitorManager defaultCacheMonitorManager = new DefaultCacheMonitorManager();
    private CacheContext cacheContext;

    public ConfigProvider() {
        this.cacheManager = SimpleCacheManager.defaultManager;
        this.encoderParser = new DefaultEncoderParser();
        this.keyConvertorParser = new DefaultKeyConvertorParser();
        this.cacheMonitorManager = this.defaultCacheMonitorManager;
    }

    @Override
    public void doInit() {
        this.initDefaultCacheMonitorInstaller();
        this.cacheContext = this.newContext();
    }

    protected void initDefaultCacheMonitorInstaller() {
        if (this.cacheMonitorManager == this.defaultCacheMonitorManager) {
            DefaultCacheMonitorManager installer = (DefaultCacheMonitorManager)this.cacheMonitorManager;
            installer.setGlobalCacheConfig(this.globalCacheConfig);
            installer.setMetricsCallback(this.metricsCallback);
            if (this.cacheMessagePublisher != null) {
                installer.setCacheMessagePublisher(this.cacheMessagePublisher);
            }
            installer.init();
        }
    }

    @Override
    public void doShutdown() {
        this.shutdownDefaultCacheMonitorInstaller();
        this.cacheManager.rebuild();
    }

    protected void shutdownDefaultCacheMonitorInstaller() {
        if (this.cacheMonitorManager == this.defaultCacheMonitorManager) {
            ((DefaultCacheMonitorManager)this.cacheMonitorManager).shutdown();
        }
    }

    public Function<Object, byte[]> parseValueEncoder(String valueEncoder) {
        return this.encoderParser.parseEncoder(valueEncoder);
    }

    public Function<byte[], Object> parseValueDecoder(String valueDecoder) {
        return this.encoderParser.parseDecoder(valueDecoder);
    }

    public Function<Object, Object> parseKeyConvertor(String convertor) {
        return this.keyConvertorParser.parseKeyConvertor(convertor);
    }

    public CacheNameGenerator createCacheNameGenerator(String[] hiddenPackages) {
        return new DefaultCacheNameGenerator(hiddenPackages);
    }

    protected CacheContext newContext() {
        return new CacheContext(this, this.globalCacheConfig);
    }

    public void setCacheManager(SimpleCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public SimpleCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setEncoderParser(EncoderParser encoderParser) {
        this.encoderParser = encoderParser;
    }

    public void setKeyConvertorParser(KeyConvertorParser keyConvertorParser) {
        this.keyConvertorParser = keyConvertorParser;
    }

    public CacheMonitorManager getCacheMonitorManager() {
        return this.cacheMonitorManager;
    }

    public void setCacheMonitorManager(CacheMonitorManager cacheMonitorManager) {
        this.cacheMonitorManager = cacheMonitorManager;
    }

    public GlobalCacheConfig getGlobalCacheConfig() {
        return this.globalCacheConfig;
    }

    public void setGlobalCacheConfig(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    public CacheContext getCacheContext() {
        return this.cacheContext;
    }

    public void setMetricsCallback(Consumer<StatInfo> metricsCallback) {
        this.metricsCallback = metricsCallback;
    }

    public void setCacheMessagePublisher(CacheMessagePublisher cacheMessagePublisher) {
        this.cacheMessagePublisher = cacheMessagePublisher;
    }
}

