/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.registry.common.model.constants.ValueConstants;
import com.alipay.sofa.registry.jraft.bootstrap.RaftClient;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.net.NetUtil;
import com.alipay.sofa.registry.server.session.bootstrap.CommonConfig;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class RaftClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftClientManager.class);
    @Autowired
    private SessionServerConfig sessionServerConfig;
    @Autowired
    private CommonConfig commonConfig;
    private RaftClient raftClient;
    private AtomicBoolean clientStart = new AtomicBoolean(false);
    private Set<String> metaIps;

    public void startRaftClient() {
        try {
            if (this.clientStart.compareAndSet(false, true)) {
                String serverConf = this.getServerConfig();
                this.raftClient = new RaftClient(this.getGroup(), serverConf);
                this.raftClient.start();
            }
        }
        catch (Exception e) {
            this.clientStart.set(false);
            LOGGER.error("Start raft client error!", (Throwable)e);
            throw new RuntimeException("Start raft client error!", e);
        }
    }

    private String getServerConfig() {
        String ret = "";
        Set<String> ips = this.getMetaIp();
        if (ips != null && !ips.isEmpty()) {
            ret = ips.stream().map(ip -> ip + ":" + ValueConstants.RAFT_SERVER_PORT).collect(Collectors.joining(","));
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("Init raft server config error!");
        }
        return ret;
    }

    public Set<String> getMetaIp() {
        Collection<String> metas;
        String localDataCenter;
        if (this.metaIps != null && !this.metaIps.isEmpty()) {
            return this.metaIps;
        }
        this.metaIps = new HashSet<String>();
        Map<String, Collection<String>> metaMap = this.commonConfig.getMetaNode();
        if (!(metaMap == null || metaMap.isEmpty() || (localDataCenter = this.sessionServerConfig.getSessionServerDataCenter()) == null || localDataCenter.isEmpty() || (metas = metaMap.get(localDataCenter)) == null || metas.isEmpty())) {
            metas.forEach(domain -> {
                String ip = NetUtil.getIPAddressFromDomain((String)domain);
                if (ip == null) {
                    throw new RuntimeException("Node config convert domain {" + domain + "} error!");
                }
                this.metaIps.add(ip);
            });
        }
        return this.metaIps;
    }

    private String getGroup() {
        return ValueConstants.RAFT_SERVER_GROUP + "_" + this.sessionServerConfig.getSessionServerDataCenter();
    }

    public PeerId getLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.getLeader()) == null) {
            LOGGER.error("[RaftClientManager] register MetaServer get no leader!");
            throw new RuntimeException("[RaftClientManager] register MetaServer get no leader!");
        }
        return leader;
    }

    public PeerId refreshLeader() {
        PeerId leader;
        if (this.raftClient == null) {
            this.startRaftClient();
        }
        if ((leader = this.raftClient.refreshLeader()) == null) {
            LOGGER.error("[RaftClientManager] refresh MetaServer get no leader!");
            throw new RuntimeException("[RaftClientManager] refresh MetaServer get no leader!");
        }
        return leader;
    }

    public AtomicBoolean getClientStart() {
        return this.clientStart;
    }
}

