/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.task.Task;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class PushTaskClosure
implements TaskClosure {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushTaskClosure.class);
    private ConcurrentHashMap<String, Task> taskMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TaskProcessor.ProcessingResult> taskResultMap = new ConcurrentHashMap();
    private TaskClosure taskClosure;
    private final BlockingQueue<String> completionQueue = new LinkedBlockingQueue<String>();
    private final ExecutorService pushTaskClosureExecutor;

    public PushTaskClosure(ExecutorService pushTaskClosureExecutor) {
        this.pushTaskClosureExecutor = pushTaskClosureExecutor;
    }

    public void run(TaskProcessor.ProcessingResult processingResult, Task task) {
        TaskProcessor.ProcessingResult existed;
        if (task != null && (existed = this.taskResultMap.putIfAbsent(task.getTaskId(), processingResult)) == null) {
            this.completionQueue.add(task.getTaskId());
        }
    }

    public void addTask(Task task) {
        this.taskMap.putIfAbsent(task.getTaskId(), task);
    }

    public void start() {
        this.pushTaskClosureExecutor.execute(() -> {
            try {
                int size = this.taskMap.size();
                LOGGER.info("Push task queue size {},map size {}", (Object)this.completionQueue.size(), (Object)size);
                for (int i = 0; i < size; ++i) {
                    TaskProcessor.ProcessingResult result;
                    String taskId = this.completionQueue.poll(6000L, TimeUnit.MILLISECONDS);
                    if (taskId == null || (result = this.taskResultMap.get(taskId)) != TaskProcessor.ProcessingResult.Success) continue;
                    this.taskMap.remove(taskId);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Push task check InterruptedException!", (Throwable)e);
            }
            if (this.taskMap.isEmpty()) {
                LOGGER.info("Push all tasks success");
                if (this.taskClosure != null) {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.Success, null);
                }
            } else {
                LOGGER.warn("Push tasks found error tasks {} !", this.taskMap);
                if (this.taskClosure != null) {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.PermanentError, null);
                }
            }
        });
    }

    public Map<String, Task> getTaskMap() {
        return this.taskMap;
    }

    public void setTaskClosure(TaskClosure taskClosure) {
        this.taskClosure = taskClosure;
    }
}

