/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.scheduler.task;

import com.alipay.sofa.registry.common.model.PushDataRetryRequest;
import com.alipay.sofa.registry.common.model.store.Subscriber;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.core.model.ReceivedData;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.service.ClientNodeService;
import com.alipay.sofa.registry.server.session.scheduler.ExecutorManager;
import com.alipay.sofa.registry.server.session.scheduler.task.AbstractSessionTask;
import com.alipay.sofa.registry.server.session.scheduler.task.PushTaskClosure;
import com.alipay.sofa.registry.server.session.strategy.ReceivedDataMultiPushTaskStrategy;
import com.alipay.sofa.registry.task.Task;
import com.alipay.sofa.registry.task.TaskClosure;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReceivedDataMultiPushTask
extends AbstractSessionTask
implements TaskClosure {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-PUSH", (String)"[Receive]");
    private final SessionServerConfig sessionServerConfig;
    private final ClientNodeService clientNodeService;
    private final ExecutorManager executorManager;
    private final Exchange boltExchange;
    private ReceivedData receivedData;
    private URL url;
    private TaskClosure taskClosure;
    private Collection<Subscriber> subscribers;
    private ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy;
    private AsyncHashedWheelTimer asyncHashedWheelTimer;

    public ReceivedDataMultiPushTask(SessionServerConfig sessionServerConfig, ClientNodeService clientNodeService, ExecutorManager executorManager, Exchange boltExchange, ReceivedDataMultiPushTaskStrategy receivedDataMultiPushTaskStrategy, AsyncHashedWheelTimer asyncHashedWheelTimer) {
        this.sessionServerConfig = sessionServerConfig;
        this.clientNodeService = clientNodeService;
        this.executorManager = executorManager;
        this.boltExchange = boltExchange;
        this.receivedDataMultiPushTaskStrategy = receivedDataMultiPushTaskStrategy;
        this.asyncHashedWheelTimer = asyncHashedWheelTimer;
    }

    public void execute() {
        if (this.sessionServerConfig.isStopPushSwitch()) {
            LOGGER.info("Stop Push ReceivedData with switch on! dataId: {},group: {},Instance: {}, url: {}", new Object[]{this.receivedData.getDataId(), this.receivedData.getGroup(), this.receivedData.getInstanceId(), this.url});
            return;
        }
        final Object receivedDataPush = this.receivedDataMultiPushTaskStrategy.convert2PushData(this.receivedData, this.url);
        CallbackHandler callbackHandler = new CallbackHandler(){

            public void onCallback(Channel channel, Object message) {
                LOGGER.info("Push ReceivedData success! dataId:{},group:{},Instance:{},version:{},url: {}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.receivedData.getInstanceId(), ReceivedDataMultiPushTask.this.receivedData.getVersion(), ReceivedDataMultiPushTask.this.url});
                if (ReceivedDataMultiPushTask.this.taskClosure != null) {
                    ReceivedDataMultiPushTask.this.confirmCallBack(true);
                }
            }

            public void onException(Channel channel, Throwable exception) {
                LOGGER.error("Push ReceivedData error! dataId:{},group:{},Instance:{},version:{},url: {}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.receivedData.getInstanceId(), ReceivedDataMultiPushTask.this.receivedData.getVersion(), ReceivedDataMultiPushTask.this.url, exception});
                if (ReceivedDataMultiPushTask.this.taskClosure != null) {
                    ReceivedDataMultiPushTask.this.confirmCallBack(false);
                    throw new RuntimeException("Push ReceivedData got exception from callback!");
                }
                ReceivedDataMultiPushTask.this.retrySendReceiveData(new PushDataRetryRequest(receivedDataPush, ReceivedDataMultiPushTask.this.url));
            }
        };
        try {
            this.clientNodeService.pushWithCallback(receivedDataPush, this.url, callbackHandler);
        }
        catch (Exception e) {
            if (this.taskClosure != null) {
                this.confirmCallBack(false);
                throw e;
            }
            this.retrySendReceiveData(new PushDataRetryRequest(receivedDataPush, this.url));
        }
    }

    private void retrySendReceiveData(final PushDataRetryRequest pushDataRetryRequest) {
        if (this.taskClosure == null) {
            Object infoPackage = pushDataRetryRequest.getPushObj();
            final int retryTimes = pushDataRetryRequest.getRetryTimes().incrementAndGet();
            final URL targetUrl = pushDataRetryRequest.getUrl();
            if (this.checkRetryTimes(retryTimes)) {
                Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
                Channel channel = sessionServer.getChannel(targetUrl);
                if (channel != null && channel.isConnected()) {
                    this.asyncHashedWheelTimer.newTimeout(timeout -> {
                        try {
                            this.clientNodeService.pushWithCallback(infoPackage, targetUrl, new CallbackHandler(){

                                public void onCallback(Channel channel, Object message) {
                                    LOGGER.info("Retry Push ReceivedData success! dataId:{}, group:{},url:{},retryTimes:{}", new Object[]{ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), targetUrl, retryTimes});
                                }

                                public void onException(Channel channel, Throwable exception) {
                                    LOGGER.error("Retry Push ReceivedData callback error! url:{}, dataId:{}, group:{},taskId:{},retryTimes:{}", new Object[]{targetUrl, ReceivedDataMultiPushTask.this.receivedData.getDataId(), ReceivedDataMultiPushTask.this.receivedData.getGroup(), ReceivedDataMultiPushTask.this.getTaskId(), retryTimes});
                                    ReceivedDataMultiPushTask.this.retrySendReceiveData(pushDataRetryRequest);
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.error("Retry Push ReceivedData error! url:{}, dataId:{}, group:{},taskId:{},retryTimes:{}", new Object[]{targetUrl, this.receivedData.getDataId(), this.receivedData.getGroup(), this.getTaskId(), retryTimes});
                            this.retrySendReceiveData(pushDataRetryRequest);
                        }
                    }, this.getBlockTime(retryTimes), TimeUnit.MILLISECONDS);
                } else {
                    LOGGER.error("Retry Push ReceivedData error, connect be null or disconnected,stop retry!dataId:{}, group:{},url:{},taskId:{},retryTimes:{}", new Object[]{this.receivedData.getDataId(), this.receivedData.getGroup(), targetUrl, this.getTaskId(), retryTimes});
                }
            } else {
                LOGGER.error("Retry Push ReceivedData times have exceeded!dataId:{}, group:{},url:{},taskId:{},retryTimes:{}", new Object[]{this.receivedData.getDataId(), this.receivedData.getGroup(), targetUrl, this.getTaskId(), retryTimes});
            }
        }
    }

    @Override
    public long getExpiryTime() {
        return -1L;
    }

    public void setTaskEvent(TaskEvent taskEvent) {
        Object obj = taskEvent.getEventObj();
        if (obj instanceof Map) {
            Map parameter = (Map)obj;
            if (parameter.size() == 1) {
                Map.Entry entry = parameter.entrySet().iterator().next();
                ReceivedData receivedData = (ReceivedData)entry.getKey();
                URL url = (URL)entry.getValue();
                this.receivedData = receivedData;
                this.url = url;
            } else {
                throw new IllegalArgumentException("Input task event object error!");
            }
        }
        this.taskClosure = taskEvent.getTaskClosure();
        if (this.taskClosure instanceof PushTaskClosure) {
            ((PushTaskClosure)this.taskClosure).addTask(this);
        }
        this.subscribers = (Collection)taskEvent.getAttribute("PUSH_CLIENT_SUBSCRIBERS");
        if (this.taskClosure != null && this.subscribers.isEmpty()) {
            LOGGER.error("send Receive data subscribers is empty!");
            throw new RuntimeException("Push Receive data got exception!send subscribers is empty");
        }
    }

    private void confirmCallBack(boolean result) {
        if (this.taskClosure != null) {
            this.executorManager.getCheckPushExecutor().execute(() -> {
                if (result) {
                    this.subscribers.forEach(subscriber -> subscriber.checkAndUpdateVersion(this.receivedData.getSegment(), this.receivedData.getVersion()));
                    this.taskClosure.run(TaskProcessor.ProcessingResult.Success, (Task)this);
                } else {
                    this.taskClosure.run(TaskProcessor.ProcessingResult.PermanentError, (Task)this);
                }
            });
        }
    }

    public String toString() {
        return "RECEIVED_DATA_MULTI_PUSH_TASK{taskId='" + this.getTaskId() + '\'' + ", receivedData=" + this.receivedData + ", url=" + this.url + ", expiryTime='" + this.getExpiryTime() + '\'' + '}';
    }

    @Override
    protected boolean checkRetryTimes(int retryTimes) {
        int configTimes = this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes();
        if (configTimes > 0) {
            return retryTimes <= configTimes;
        }
        return false;
    }

    private long getBlockTime(int retry) {
        long increment;
        long initialSleepTime = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getPushDataTaskRetryFirstDelay());
        long result = initialSleepTime + (increment = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getPushDataTaskRetryIncrementDelay())) * (long)(retry - 1);
        return result >= 0L ? result : 0L;
    }

    public boolean checkRetryTimes() {
        return this.checkRetryTimes(this.sessionServerConfig.getReceivedDataMultiPushTaskRetryTimes());
    }

    public void run(TaskProcessor.ProcessingResult processingResult, Task task) {
        if (this.taskClosure != null) {
            this.taskClosure.run(processingResult, task);
        }
    }
}

