/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.store;

import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.server.session.store.DataStore;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionDataStore
implements DataStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionDataStore.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock write = this.readWriteLock.writeLock();
    private Map<String, Map<String, Publisher>> registry = new ConcurrentHashMap<String, Map<String, Publisher>>();
    private Map<String, Map<String, Publisher>> connectIndex = new ConcurrentHashMap<String, Map<String, Publisher>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Publisher publisher) {
        this.write.lock();
        try {
            Publisher existingPublisher;
            ConcurrentHashMap<String, Publisher> publishers = this.registry.get(publisher.getDataInfoId());
            if (publishers == null) {
                ConcurrentHashMap<String, Publisher> newmap = new ConcurrentHashMap<String, Publisher>();
                publishers = this.registry.putIfAbsent(publisher.getDataInfoId(), newmap);
                if (publishers == null) {
                    publishers = newmap;
                }
            }
            if ((existingPublisher = publishers.get(publisher.getRegisterId())) != null) {
                if (existingPublisher.getVersion() != null) {
                    long oldVersion = existingPublisher.getVersion();
                    Long newVersion = publisher.getVersion();
                    if (newVersion == null) {
                        LOGGER.error("There is publisher input version can't be null!");
                        return;
                    }
                    if (oldVersion > newVersion) {
                        LOGGER.warn("There is publisher already exists,but old version {} higher than input {},it will not be overwrite! {}", new Object[]{oldVersion, newVersion, existingPublisher});
                        return;
                    }
                    if (oldVersion == newVersion) {
                        Long newTime = publisher.getRegisterTimestamp();
                        long oldTime = existingPublisher.getRegisterTimestamp();
                        if (newTime == null) {
                            LOGGER.error("There is publisher input Register Timestamp can not be null!");
                            return;
                        }
                        if (oldTime > newTime) {
                            LOGGER.warn("There is publisher already exists,but old timestamp {} higher than input {},it will not be overwrite! {}", new Object[]{oldTime, newTime, existingPublisher});
                            return;
                        }
                    }
                }
                LOGGER.warn("There is publisher already exists,version:{},it will be overwrite!Input version:{},info:{}", new Object[]{existingPublisher.getVersion(), publisher.getVersion(), existingPublisher});
            }
            publishers.put(publisher.getRegisterId(), publisher);
            this.addIndex(publisher);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteById(String registerId, String dataInfoId) {
        this.write.lock();
        try {
            Map<String, Publisher> publishers = this.registry.get(dataInfoId);
            if (publishers == null) {
                LOGGER.error("Delete failed because publisher is not registered for dataInfoId: {}", (Object)dataInfoId);
                boolean bl = false;
                return bl;
            }
            Publisher publisherTodelete = publishers.remove(registerId);
            if (publisherTodelete == null) {
                LOGGER.error("Delete failed because publisher is not registered for registerId: {}", (Object)registerId);
                boolean bl = false;
                return bl;
            }
            this.removeIndex(publisherTodelete);
            boolean bl = true;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Map<String, Publisher> queryByConnectId(String connectId) {
        return this.connectIndex.get(connectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByConnectId(String connectId) {
        this.write.lock();
        try {
            for (Map<String, Publisher> map : this.registry.values()) {
                Iterator<Publisher> it = map.values().iterator();
                while (it.hasNext()) {
                    Publisher publisher = it.next();
                    if (publisher == null || !connectId.equals(publisher.getSourceAddress().getAddressString())) continue;
                    it.remove();
                    this.invalidateIndex(publisher);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Delete publisher by connectId {} error!", (Object)connectId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Collection<Publisher> getStoreDataByDataInfoId(String dataInfoId) {
        Map<String, Publisher> publishers = this.registry.get(dataInfoId);
        if (publishers == null) {
            LOGGER.info("There is not registered publisher for dataInfoId: {}", (Object)dataInfoId);
            return null;
        }
        return publishers.values();
    }

    @Override
    public Publisher queryById(String registerId, String dataInfoId) {
        Map<String, Publisher> publishers = this.registry.get(dataInfoId);
        if (publishers == null) {
            LOGGER.error("Publisher is not registered for dataInfoId: {}", (Object)dataInfoId);
            return null;
        }
        return publishers.get(registerId);
    }

    @Override
    public long count() {
        AtomicLong count = new AtomicLong(0L);
        for (Map<String, Publisher> map : this.registry.values()) {
            count.addAndGet(map.size());
        }
        return count.get();
    }

    private void addIndex(Publisher publisher) {
        this.addConnectIndex(publisher);
    }

    private void addConnectIndex(Publisher publisher) {
        ConcurrentHashMap<String, Publisher> newPublisherMap;
        String connectId = publisher.getSourceAddress().getAddressString();
        ConcurrentHashMap<String, Publisher> publisherMap = this.connectIndex.get(connectId);
        if (publisherMap == null && (publisherMap = (ConcurrentHashMap<String, Publisher>)this.connectIndex.putIfAbsent(connectId, newPublisherMap = new ConcurrentHashMap<String, Publisher>())) == null) {
            publisherMap = newPublisherMap;
        }
        publisherMap.put(publisher.getRegisterId(), publisher);
    }

    private void removeIndex(Publisher publisher) {
        this.removeConnectIndex(publisher);
    }

    private void removeConnectIndex(Publisher publisher) {
        String connectId = publisher.getSourceAddress().getAddressString();
        Map<String, Publisher> publisherMap = this.connectIndex.get(connectId);
        if (publisherMap != null) {
            publisherMap.remove(publisher.getRegisterId());
        } else {
            LOGGER.warn("ConnectId {} not existed in Index to remove!", (Object)connectId);
        }
    }

    private void invalidateIndex(Publisher publisher) {
        String connectId = publisher.getSourceAddress().getAddressString();
        this.invalidateConnectIndex(connectId);
    }

    private void invalidateConnectIndex(String connectId) {
        this.connectIndex.remove(connectId);
    }
}

