/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.udf.utils;

import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;

public class CounterUtils {
    public static String toJsonString(Counters counters) {
        JsonObject js = CounterUtils.toJson(counters);
        return js.toString();
    }

    public static Counters createFromJsonString(String json) {
        JsonParser parser = new JsonParser();
        JsonElement el = parser.parse(json);
        return CounterUtils.createFromJson(el.getAsJsonObject());
    }

    private static Counters createFromJson(JsonObject obj) {
        Counters counters = new Counters();
        for (Map.Entry entry : obj.entrySet()) {
            String key = (String)entry.getKey();
            CounterGroup group = counters.getGroup(key);
            CounterUtils.fromJson(group, ((JsonElement)entry.getValue()).getAsJsonObject());
        }
        return counters;
    }

    private static void fromJson(CounterGroup group, JsonObject obj) {
        JsonArray counterArray = obj.get("counters").getAsJsonArray();
        for (int i = 0; i < counterArray.size(); ++i) {
            JsonObject subObj = counterArray.get(i).getAsJsonObject();
            String counterName = subObj.get("name").getAsString();
            Counter counter = group.findCounter(counterName);
            long value = subObj.get("value").getAsLong();
            counter.increment(value);
        }
    }

    private static JsonObject toJson(Counters counters) {
        JsonObject obj = new JsonObject();
        for (CounterGroup group : counters) {
            obj.add(group.getName(), (JsonElement)CounterUtils.toJson(group));
        }
        return obj;
    }

    private static JsonObject toJson(CounterGroup counterGroup) {
        JsonObject obj = new JsonObject();
        obj.addProperty("name", counterGroup.getName());
        JsonArray counterArray = new JsonArray();
        for (Counter entry : counterGroup) {
            counterArray.add((JsonElement)CounterUtils.toJson(entry));
        }
        obj.add("counters", (JsonElement)counterArray);
        return obj;
    }

    private static JsonObject toJson(Counter counter) {
        JsonObject js = new JsonObject();
        js.addProperty("name", counter.getName());
        js.addProperty("value", (Number)counter.getValue());
        return js;
    }
}

