/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyValue;

public class PrimaryKeyRange {
    private String primaryKeyName;
    private PrimaryKeyValue begin;
    private PrimaryKeyValue end;
    private PrimaryKeyType type;
    public static final PrimaryKeyValue INF_MAX = new PrimaryKeyValue("INF_MAX", null);
    public static final PrimaryKeyValue INF_MIN = new PrimaryKeyValue("INF_MIN", null);

    PrimaryKeyRange() {
    }

    public PrimaryKeyRange(String primaryKeyName, PrimaryKeyValue begin, PrimaryKeyValue end) {
        this(primaryKeyName, begin, end, begin != null && begin.getType() != null ? begin.getType() : (end != null && end.getType() != null ? end.getType() : PrimaryKeyType.STRING));
    }

    public PrimaryKeyRange(String primaryKeyName, PrimaryKeyValue begin, PrimaryKeyValue end, PrimaryKeyType type) {
        if (primaryKeyName == null || begin == null || end == null || type == null) {
            throw new NullPointerException();
        }
        OTSUtil.ensureNameValid(primaryKeyName);
        if (!PrimaryKeyRange.isInf(begin) && begin.getType() != type) {
            throw new IllegalArgumentException("begin\u7684\u6570\u636e\u7c7b\u578b\u5e94\u4e0etype\u7ed9\u5b9a\u7684\u4e00\u81f4\u3002");
        }
        if (!PrimaryKeyRange.isInf(end) && end.getType() != type) {
            throw new IllegalArgumentException("end\u7684\u6570\u636e\u7c7b\u578b\u5e94\u4e0etype\u7ed9\u5b9a\u7684\u4e00\u81f4\u3002");
        }
        this.primaryKeyName = primaryKeyName;
        this.begin = begin;
        this.end = end;
        this.type = type;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public PrimaryKeyValue getBegin() {
        return this.begin;
    }

    public PrimaryKeyValue getEnd() {
        return this.end;
    }

    public PrimaryKeyType getType() {
        return this.type;
    }

    private static boolean isInf(PrimaryKeyValue pkValue) {
        return pkValue.equals(INF_MAX) || pkValue.equals(INF_MIN);
    }
}

