/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.StringUtils;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.DataSerializable;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.SerializationUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceTransaction
implements ResourceTransaction,
Externalizable,
Participant,
DataSerializable {
    private static final Logger LOGGER = LoggerFactory.createLogger(XAResourceTransaction.class);
    static final long serialVersionUID = -8227293322090019196L;
    private String tid;
    private String root;
    private boolean isXaSuspended;
    private TxState state;
    private String resourcename;
    private transient Xid xid;
    private transient String xidToHexString;
    private transient String toString;
    private transient XATransactionalResource resource;
    private transient XAResource xaresource;
    private Vector<HeuristicMessage> heuristicMessages;
    private transient boolean knownInResource;
    private transient int timeout;

    protected static String interpretErrorCode(String resourceName, String opCode, Xid xid, int errorCode) {
        String msg = "unkown";
        switch (errorCode) {
            case -7: {
                msg = "the XA resource has become unavailable";
                break;
            }
            case 100: {
                msg = "the XA resource has rolled back for an unspecified reason";
                break;
            }
            case 101: {
                msg = "the XA resource rolled back due to a communication failure";
                break;
            }
            case 102: {
                msg = "the XA resource has rolled back because of a deadlock";
                break;
            }
            case 103: {
                msg = "the XA resource has rolled back due to a constraint violation";
                break;
            }
            case 104: {
                msg = "the XA resource has rolled back for an unknown reason";
                break;
            }
            case 105: {
                msg = "the XA resource has rolled back because it did not expect this command in the current context";
                break;
            }
            case 106: {
                msg = "the XA resource has rolled back because the transaction took too long";
                break;
            }
            case 107: {
                msg = "the XA resource has rolled back for a temporary reason - the transaction can be retried later";
                break;
            }
            case 9: {
                msg = "XA resume attempted in a different place from where suspend happened";
                break;
            }
            case 8: {
                msg = "the XA resource may have heuristically completed the transaction";
                break;
            }
            case 7: {
                msg = "the XA resource has heuristically committed";
                break;
            }
            case 6: {
                msg = "the XA resource has heuristically rolled back";
                break;
            }
            case 5: {
                msg = "the XA resource has heuristically committed some parts and rolled back other parts";
                break;
            }
            case 4: {
                msg = "the XA command had no effect and may be retried";
                break;
            }
            case 3: {
                msg = "the XA resource had no updates to perform for this transaction";
                break;
            }
            case -3: {
                msg = "the XA resource detected an internal error";
                break;
            }
            case -4: {
                msg = "the supplied XID is invalid for this XA resource";
                break;
            }
            case -5: {
                msg = "invalid arguments were given for the XA operation";
                break;
            }
            case -6: {
                msg = "the XA resource did not expect this command in the current context";
                break;
            }
            case -8: {
                msg = "the supplied XID already exists in this XA resource";
                break;
            }
            case -9: {
                msg = "the XA resource is currently involved in a local (non-XA) transaction";
                break;
            }
            default: {
                msg = "unknown";
            }
        }
        return "XA resource '" + resourceName + "': " + opCode + " for XID '" + XAResourceTransaction.xidToHexString(xid) + "' raised " + errorCode + ": " + msg;
    }

    private void setXid(Xid xid) {
        this.xid = xid;
        this.xidToHexString = XAResourceTransaction.xidToHexString(xid);
        this.toString = "XAResourceTransaction: " + this.xidToHexString;
    }

    public XAResourceTransaction() {
    }

    XAResourceTransaction(XATransactionalResource resource, CompositeTransaction transaction, String root) {
        this.setResource(resource);
        TransactionControl control = transaction.getTransactionControl();
        if (control != null) {
            this.timeout = (int)transaction.getTransactionControl().getTimeout() / 1000;
        }
        this.tid = transaction.getTid();
        this.root = root;
        this.resourcename = resource.getName();
        this.setXid(this.resource.createXid(this.tid));
        this.setState(TxState.ACTIVE);
        this.heuristicMessages = new Vector();
        this.isXaSuspended = false;
        this.knownInResource = false;
        this.addHeuristicMessage((HeuristicMessage)new StringHeuristicMessage("XA resource '" + resource.getName() + "' accessed with Xid '" + this.xidToHexString + "'"));
    }

    void setResource(XATransactionalResource resource) {
        this.resource = resource;
    }

    void setState(TxState state) {
        this.state = state;
    }

    static String xidToHexString(Xid xid) {
        String gtrid = StringUtils.byteArrayToHexString(xid.getGlobalTransactionId());
        String bqual = StringUtils.byteArrayToHexString(xid.getBranchQualifier());
        return gtrid + ":" + bqual;
    }

    private void switchToHeuristicState(String opCode, TxState state, XAException cause) {
        String errorMsg = XAResourceTransaction.interpretErrorCode(this.resourcename, opCode, this.xid, cause.errorCode);
        this.addHeuristicMessage((HeuristicMessage)new StringHeuristicMessage(errorMsg));
        this.setState(state);
    }

    protected void testOrRefreshXAResourceFor2PC() throws XAException {
        try {
            if (this.state.equals((Object)TxState.HEUR_HAZARD)) {
                this.forceRefreshXAConnection();
            } else if (this.xaresource != null) {
                this.assertConnectionIsStillAlive();
            }
        }
        catch (XAException xa) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this.resourcename + ": XAResource needs refresh", (Throwable)xa);
            }
            if (this.resource == null) {
                this.throwXAExceptionForUnavailableResource();
            }
            this.xaresource = this.resource.getXAResource();
        }
    }

    private void assertConnectionIsStillAlive() throws XAException {
        this.xaresource.isSameRM(this.xaresource);
    }

    protected void forceRefreshXAConnection() throws XAException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this.resourcename + ": forcing refresh of XAConnection...");
        }
        if (this.resource == null) {
            this.throwXAExceptionForUnavailableResource();
        }
        try {
            this.xaresource = this.resource.refreshXAConnection();
        }
        catch (ResourceException re) {
            LOGGER.logWarning(this.resourcename + ": could not refresh XAConnection", (Throwable)re);
        }
    }

    private void throwXAExceptionForUnavailableResource() throws XAException {
        String msg = this.resourcename + ": resource no longer available - recovery might be at risk!";
        LOGGER.logWarning(msg);
        XAException err = new XAException(msg);
        err.errorCode = -7;
        throw err;
    }

    private void terminateInResource() {
        if (this.resource != null) {
            this.resource.removeSiblingMap(this.root);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.xid);
        out.writeObject(this.tid);
        out.writeObject(this.root);
        out.writeObject(this.state);
        out.writeObject(this.heuristicMessages.clone());
        out.writeObject(this.resourcename);
        if (this.xaresource instanceof Serializable) {
            out.writeObject(Boolean.TRUE);
            out.writeObject(this.xaresource);
        } else {
            out.writeObject(Boolean.FALSE);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setXid((Xid)in.readObject());
        this.tid = (String)in.readObject();
        this.root = (String)in.readObject();
        this.state = (TxState)in.readObject();
        this.heuristicMessages = (Vector)in.readObject();
        this.resourcename = (String)in.readObject();
        try {
            Boolean xaresSerializable = (Boolean)in.readObject();
            if (xaresSerializable != null && xaresSerializable.booleanValue()) {
                this.xaresource = (XAResource)in.readObject();
            }
        }
        catch (OptionalDataException e) {
            LOGGER.logDebug("Ignoring missing field", (Throwable)e);
        }
    }

    public String getTid() {
        return this.tid;
    }

    public void addHeuristicMessage(HeuristicMessage mesg) throws IllegalStateException {
        if (mesg != null && mesg.toString() != null) {
            this.heuristicMessages.addElement(mesg);
        }
    }

    public HeuristicMessage[] getHeuristicMessages() {
        HeuristicMessage[] heurArray = new HeuristicMessage[1];
        return this.heuristicMessages.toArray(heurArray);
    }

    public synchronized void suspend() throws ResourceException {
        if (this.state.equals((Object)TxState.ACTIVE)) {
            block4: {
                try {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.logInfo("XAResource.end ( " + this.xidToHexString + " , XAResource.TMSUCCESS ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                    }
                    this.xaresource.end(this.xid, 0x4000000);
                }
                catch (XAException xaerr) {
                    String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "end", this.xid, xaerr.errorCode);
                    if (!LOGGER.isDebugEnabled()) break block4;
                    LOGGER.logDebug(msg, (Throwable)xaerr);
                }
            }
            this.setState(TxState.LOCALLY_DONE);
        }
    }

    boolean supportsTmJoin() {
        return !this.resource.usesWeakCompare() && !this.resource.acceptsAllXAResources() && !this.isActive();
    }

    public synchronized void resume() throws ResourceException {
        int flag = 0;
        Stack errors = new Stack();
        String logFlag = "";
        if (this.state.equals((Object)TxState.LOCALLY_DONE)) {
            flag = 0x200000;
            logFlag = "XAResource.TMJOIN";
        } else if (!this.knownInResource) {
            flag = 0;
            logFlag = "XAResource.TMNOFLAGS";
        } else {
            throw new IllegalStateException("Wrong state for resume: " + this.state);
        }
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("XAResource.start ( " + this.xidToHexString + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, flag);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw new ResourceException(msg, (Throwable)xaerr);
        }
        this.setState(TxState.ACTIVE);
        this.knownInResource = true;
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
    }

    public Object getState() {
        return this.state;
    }

    public boolean recover() throws SysException {
        boolean recovered = false;
        if (this.beforePrepare()) {
            return false;
        }
        recovered = this.tryRecoverWithEveryResourceToEnsureOurXidIsNotEndedByPresumedAbort();
        if (!recovered && this.getXAResource() != null) {
            recovered = true;
        }
        if (recovered) {
            this.knownInResource = true;
        }
        return recovered;
    }

    private boolean beforePrepare() {
        return TxState.ACTIVE.equals((Object)this.state) || TxState.LOCALLY_DONE.equals((Object)this.state);
    }

    private boolean tryRecoverWithEveryResourceToEnsureOurXidIsNotEndedByPresumedAbort() {
        boolean ret = false;
        Enumeration resources = Configuration.getResources();
        while (resources.hasMoreElements()) {
            RecoverableResource res = (RecoverableResource)resources.nextElement();
            if (!res.recover((Participant)this)) continue;
            ret = true;
        }
        return ret;
    }

    public void setGlobalSiblingCount(int count) {
    }

    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource != null) {
                this.xaresource.forget(this.xid);
            }
        }
        catch (Exception err) {
            LOGGER.logDebug("Error forgetting xid: " + this.xid, (Throwable)err);
        }
        this.setState(TxState.TERMINATED);
    }

    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 0;
        this.terminateInResource();
        if (TxState.ACTIVE.equals((Object)this.state)) {
            this.suspend();
        }
        if (this.state.equals((Object)TxState.IN_DOUBT)) {
            return 0;
        }
        if (!this.state.equals((Object)TxState.LOCALLY_DONE)) {
            throw new SysException("Wrong state for prepare: " + this.state);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("About to call prepare on XAResource instance: " + this.xaresource);
            }
            ret = this.xaresource.prepare(this.xid);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "prepare", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                throw new RollbackException(msg);
            }
            throw new SysException(msg, (Throwable)xaerr);
        }
        this.setState(TxState.IN_DOUBT);
        if (ret == 3) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("XAResource.prepare ( " + this.xidToHexString + " ) returning XAResource.XA_RDONLY " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            return 0;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("XAResource.prepare ( " + this.xidToHexString + " ) returning OK " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
        }
        return 1;
    }

    public synchronized HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.terminateInResource();
        if (this.rollbackShouldDoNothing()) {
            return null;
        }
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException(this.getHeuristicMessages());
        }
        if (this.xaresource == null) {
            LOGGER.logWarning("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback - the required resource is probably not yet intialized?");
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (this.state.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("XAResource.rollback ( " + this.xidToHexString + " ) " + "on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.rollback(this.xid);
        }
        catch (ResourceException resErr) {
            throw new SysException("Error in rollback: " + resErr.getMessage(), (Throwable)resErr);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "rollback", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(msg);
                }
            }
            LOGGER.logWarning(msg, (Throwable)xaerr);
            switch (xaerr.errorCode) {
                case 8: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_HAZARD, xaerr);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_MIXED, xaerr);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_COMMITTED, xaerr);
                    throw new HeurCommitException(this.getHeuristicMessages());
                }
                case 6: {
                    this.forget();
                    break;
                }
                case -4: {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("XAResource.rollback: invalid Xid - already rolled back in resource?");
                    }
                    this.setState(TxState.TERMINATED);
                    break;
                }
                default: {
                    this.switchToHeuristicState("rollback", TxState.HEUR_HAZARD, xaerr);
                    throw new SysException(msg, (Throwable)xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
        return this.getHeuristicMessages();
    }

    private boolean rollbackShouldDoNothing() {
        return !this.knownInResource && this.beforePrepare();
    }

    public synchronized HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        this.terminateInResource();
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return this.getHeuristicMessages();
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException(this.getHeuristicMessages());
        }
        if (this.state.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException(this.getHeuristicMessages());
        }
        if (this.xaresource == null) {
            LOGGER.logWarning("XAResourceTransaction " + this.getXid() + ": no XAResource to commit - the required resource is probably not yet intialized?");
            throw new HeurHazardException(this.getHeuristicMessages());
        }
        try {
            if (TxState.ACTIVE.equals((Object)this.state)) {
                this.suspend();
            }
        }
        catch (ResourceException re) {
            throw new RollbackException(re.getMessage());
        }
        if (!(this.state.equals((Object)TxState.LOCALLY_DONE) || this.state.equals((Object)TxState.IN_DOUBT) || this.state.equals((Object)TxState.HEUR_HAZARD))) {
            throw new SysException("Wrong state for commit: " + this.state);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("XAResource.commit ( " + this.xidToHexString + " , " + onePhase + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.commit(this.xid, onePhase);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "commit", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (!onePhase) {
                    throw new SysException(msg, (Throwable)xaerr);
                }
                throw new RollbackException("Already rolled back in resource.");
            }
            switch (xaerr.errorCode) {
                case 8: {
                    this.switchToHeuristicState("commit", TxState.HEUR_HAZARD, xaerr);
                    throw new HeurHazardException(this.getHeuristicMessages());
                }
                case 5: {
                    this.switchToHeuristicState("commit", TxState.HEUR_MIXED, xaerr);
                    throw new HeurMixedException(this.getHeuristicMessages());
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.switchToHeuristicState("commit", TxState.HEUR_ABORTED, xaerr);
                    throw new HeurRollbackException(this.getHeuristicMessages());
                }
                case -4: {
                    if (!onePhase) {
                        LOGGER.logWarning("XAResource.commit: invalid Xid - transaction already committed in resource?");
                        this.setState(TxState.TERMINATED);
                        break;
                    }
                }
                default: {
                    this.switchToHeuristicState("commit", TxState.HEUR_HAZARD, xaerr);
                    throw new SysException(msg, (Throwable)xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
        return this.getHeuristicMessages();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction other = (XAResourceTransaction)o;
        return this.xid.equals(other.xid);
    }

    public int hashCode() {
        return this.xidToHexString.hashCode();
    }

    public String toString() {
        return this.toString;
    }

    public Xid getXid() {
        return this.xid;
    }

    protected void setRecoveredXAResource(XAResource xaresource) {
        if (!TxState.ACTIVE.equals((Object)this.state)) {
            this.setXAResource(xaresource);
        }
    }

    public void setXAResource(XAResource xaresource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": about to switch to XAResource " + xaresource);
        }
        this.xaresource = xaresource;
        try {
            this.xaresource.setTransactionTimeout(this.timeout);
        }
        catch (XAException e) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "setTransactionTimeout", this.xid, e.errorCode);
            LOGGER.logWarning(msg, (Throwable)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xaresource);
        }
    }

    public void xaSuspend() throws XAException {
        if (!this.isXaSuspended) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.logInfo("XAResource.suspend ( " + this.xidToHexString + " , XAResource.TMSUSPEND ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                }
                this.xaresource.end(this.xid, 0x2000000);
                this.isXaSuspended = true;
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "suspend", this.xid, xaerr.errorCode);
                LOGGER.logWarning(msg, (Throwable)xaerr);
                throw xaerr;
            }
        }
    }

    public void xaResume() throws XAException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("XAResource.start ( " + this.xidToHexString + " , XAResource.TMRESUME ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, 0x8000000);
            this.isXaSuspended = false;
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw xaerr;
        }
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended;
    }

    public boolean isActive() {
        return this.state.equals((Object)TxState.ACTIVE);
    }

    public String getURI() {
        return null;
    }

    String getResourceName() {
        return this.resourcename;
    }

    XAResource getXAResource() {
        return this.xaresource;
    }

    public void writeData(DataOutput out) throws IOException {
        byte[] data = SerializationUtils.serialize((Serializable)((Serializable)((Object)this.xid)));
        out.writeInt(data.length);
        out.write(data);
        out.writeUTF(this.tid);
        out.writeUTF(this.root);
        out.writeUTF(this.state.toString());
        out.writeUTF(this.resourcename);
        out.writeInt(this.heuristicMessages.size());
        Iterator<HeuristicMessage> i$ = this.heuristicMessages.iterator();
        while (i$.hasNext()) {
            HeuristicMessage heuristicMessage2;
            HeuristicMessage heuristicMessage = heuristicMessage2 = i$.next();
            out.writeUTF(heuristicMessage.toString());
        }
        if (this.xaresource instanceof Serializable) {
            out.writeBoolean(true);
            byte[] bytes = SerializationUtils.serialize((Serializable)((Serializable)((Object)this.xaresource)));
            out.writeInt(bytes.length);
            out.write(bytes);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readData(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] data = new byte[len];
        in.readFully(data);
        this.xid = (Xid)SerializationUtils.deserialize((byte[])data);
        this.tid = in.readUTF();
        this.setXid(this.xid);
        this.root = in.readUTF();
        this.state = TxState.valueOf((String)in.readUTF());
        this.resourcename = in.readUTF();
        int nbMessages = in.readInt();
        this.heuristicMessages = new Vector(nbMessages);
        for (int i = 0; i < nbMessages; ++i) {
            this.heuristicMessages.add((HeuristicMessage)new StringHeuristicMessage(in.readUTF()));
        }
        boolean xaresourceSerializable = in.readBoolean();
        if (xaresourceSerializable) {
            int size = in.readInt();
            byte[] bytes = new byte[size];
            in.readFully(bytes);
            this.xaresource = (XAResource)SerializationUtils.deserialize((byte[])bytes);
        }
    }
}

