/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.ResumePreviousTransactionSubTxAwareParticipant;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.jta.TransactionManagerFactory;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class TransactionManagerImp
implements TransactionManager,
SubTxAwareParticipant,
Referenceable,
UserTransaction {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionManagerImp.class);
    private static final long serialVersionUID = -3048879409985542685L;
    public static final String JTA_PROPERTY_NAME = "com.atomikos.icatch.jta.transaction";
    private static TransactionManagerImp singleton = null;
    private static int defaultTimeoutInSecondsForNewTransactions;
    private static boolean jtaTransactionsAreSerialByDefault;
    private int timeoutInSecondsForNewTransactions;
    private Map<String, TransactionImp> jtaTransactionToCoreTransactionMap;
    private CompositeTransactionManager compositeTransactionManager;
    private boolean enableAutomatRegistrationOfUnknownXAResources;

    private static final void raiseNoTransaction() {
        StringBuffer msg = new StringBuffer();
        msg.append("This method needs a transaction for the calling thread and none exists.\n");
        msg.append("Possible causes: either you didn't start a transaction,\n");
        msg.append("it rolledback due to timeout, or it was committed already.\n");
        msg.append("ACTIONS: You can try one of the following: \n");
        msg.append("1. Make sure you started a transaction for the thread.\n");
        msg.append("2. Make sure you didn't terminate it yet.\n");
        msg.append("3. Increase the transaction timeout to avoid automatic rollback of long transactions;\n");
        msg.append("   check http://www.atomikos.com/Documentation/JtaProperties for how to do this.");
        LOGGER.logWarning(msg.toString());
        throw new IllegalStateException(msg.toString());
    }

    public static void setDefaultSerial(boolean value) {
        jtaTransactionsAreSerialByDefault = value;
    }

    public static boolean getDefaultSerial() {
        return jtaTransactionsAreSerialByDefault;
    }

    public static void setDefaultTimeout(int defaultTimeoutValueInSeconds) {
        defaultTimeoutInSecondsForNewTransactions = defaultTimeoutValueInSeconds;
    }

    public static int getDefaultTimeout() {
        return defaultTimeoutInSecondsForNewTransactions;
    }

    public static synchronized void installTransactionManager(CompositeTransactionManager ctm, boolean automaticResourceRegistration) {
        singleton = ctm != null ? new TransactionManagerImp(ctm, automaticResourceRegistration) : null;
    }

    public static TransactionManager getTransactionManager() {
        return singleton;
    }

    private TransactionManagerImp(CompositeTransactionManager ctm, boolean automaticResourceRegistration) {
        this.compositeTransactionManager = ctm;
        this.timeoutInSecondsForNewTransactions = defaultTimeoutInSecondsForNewTransactions;
        this.jtaTransactionToCoreTransactionMap = new HashMap<String, TransactionImp>();
        this.enableAutomatRegistrationOfUnknownXAResources = automaticResourceRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(String tid, TransactionImp tx) {
        Map<String, TransactionImp> map = this.jtaTransactionToCoreTransactionMap;
        synchronized (map) {
            this.jtaTransactionToCoreTransactionMap.put(tid.toString(), tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(String tid) {
        Map<String, TransactionImp> map = this.jtaTransactionToCoreTransactionMap;
        synchronized (map) {
            this.jtaTransactionToCoreTransactionMap.remove(tid);
        }
    }

    private CompositeTransaction getCompositeTransaction() throws ExtendedSystemException {
        CompositeTransaction ct = null;
        try {
            ct = this.compositeTransactionManager.getCompositeTransaction();
        }
        catch (SysException se) {
            String msg = "Error while retrieving the transaction for the calling thread";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        this.establishJtaTransactionContextIfNecessary(ct);
        return ct;
    }

    private void establishJtaTransactionContextIfNecessary(CompositeTransaction ct) {
        TransactionImp jtaTransaction;
        if (this.isJtaTransaction(ct) && (jtaTransaction = this.getJtaTransactionWithId(ct.getTid())) == null) {
            this.recreateCompositeTransactionAsJtaTransaction(ct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionImp getJtaTransactionWithId(String tid) {
        TransactionImp ret = null;
        Map<String, TransactionImp> map = this.jtaTransactionToCoreTransactionMap;
        synchronized (map) {
            if (this.jtaTransactionToCoreTransactionMap.containsKey(tid.toString())) {
                ret = this.jtaTransactionToCoreTransactionMap.get(tid.toString());
            }
        }
        return ret;
    }

    public Transaction getTransaction(String tid) {
        return this.getJtaTransactionWithId(tid);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.timeoutInSecondsForNewTransactions);
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        CompositeTransaction ct = null;
        ResumePreviousTransactionSubTxAwareParticipant resumeParticipant = null;
        ct = this.compositeTransactionManager.getCompositeTransaction();
        if (ct != null && ct.getProperty(JTA_PROPERTY_NAME) == null) {
            LOGGER.logWarning("JTA: temporarily suspending incompatible transaction: " + ct.getTid() + " (will be resumed after JTA transaction ends)");
            ct = this.compositeTransactionManager.suspend();
            resumeParticipant = new ResumePreviousTransactionSubTxAwareParticipant(ct);
        }
        try {
            ct = this.compositeTransactionManager.createCompositeTransaction((long)timeout * 1000L);
            if (resumeParticipant != null) {
                ct.addSubTxAwareParticipant(resumeParticipant);
            }
            if (ct.isRoot() && TransactionManagerImp.getDefaultSerial()) {
                ct.getTransactionControl().setSerial();
            }
            ct.setProperty(JTA_PROPERTY_NAME, "true");
        }
        catch (SysException se) {
            String msg = "Error in begin()";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        this.recreateCompositeTransactionAsJtaTransaction(ct);
    }

    public Transaction getTransaction() throws SystemException {
        TransactionImp ret = null;
        CompositeTransaction ct = this.getCompositeTransaction();
        if (ct != null) {
            ret = this.getJtaTransactionWithId(ct.getTid());
        }
        return ret;
    }

    private TransactionImp recreateCompositeTransactionAsJtaTransaction(CompositeTransaction ct) {
        TransactionImp ret = null;
        if (ct.getState().equals((Object)TxState.ACTIVE)) {
            ret = new TransactionImp(ct, this.enableAutomatRegistrationOfUnknownXAResources);
            this.addToMap(ct.getTid(), ret);
            ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        }
        return ret;
    }

    private boolean isJtaTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (ct != null && ct.getProperty(JTA_PROPERTY_NAME) != null) {
            ret = true;
        }
        return ret;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds > 0) {
            this.timeoutInSecondsForNewTransactions = seconds;
        } else if (seconds == 0) {
            this.timeoutInSecondsForNewTransactions = defaultTimeoutInSecondsForNewTransactions;
        } else {
            String msg = "setTransactionTimeout: value must be >= 0";
            LOGGER.logWarning(msg);
            throw new SystemException(msg);
        }
    }

    public int getTransactionTimeout() {
        return this.timeoutInSecondsForNewTransactions;
    }

    public Transaction suspend() throws SystemException {
        TransactionImp ret = (TransactionImp)this.getTransaction();
        if (ret != null) {
            this.suspendUnderlyingCompositeTransaction();
            ret.suspendEnlistedXaResources();
        }
        return ret;
    }

    private void suspendUnderlyingCompositeTransaction() throws ExtendedSystemException {
        CompositeTransaction ct = null;
        try {
            ct = this.compositeTransactionManager.suspend();
        }
        catch (SysException se) {
            String msg = "Unexpected error while suspending the existing transaction for the current thread";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (tobj == null || !(tobj instanceof TransactionImp)) {
            String msg = "The specified transaction object is invalid for this configuration: " + tobj;
            LOGGER.logWarning(msg);
            throw new InvalidTransactionException(msg);
        }
        TransactionImp tximp = (TransactionImp)tobj;
        try {
            this.compositeTransactionManager.resume(tximp.getCT());
        }
        catch (SysException se) {
            String msg = "Unexpected error while resuming the transaction in the calling thread";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se.getErrors());
        }
        tximp.resumeEnlistedXaReources();
    }

    public int getStatus() throws SystemException {
        int ret = 6;
        Transaction tx = this.getTransaction();
        ret = tx == null ? 6 : tx.getStatus();
        return ret;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            TransactionManagerImp.raiseNoTransaction();
        }
        tx.commit();
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            TransactionManagerImp.raiseNoTransaction();
        }
        tx.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Stack<SecurityException> errors = new Stack<SecurityException>();
        Transaction tx = this.getTransaction();
        if (tx == null) {
            TransactionManagerImp.raiseNoTransaction();
        }
        try {
            tx.setRollbackOnly();
        }
        catch (SecurityException se) {
            errors.push(se);
            String msg = "Unexpected error during setRollbackOnly";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, errors);
        }
    }

    public void committed(CompositeTransaction tx) {
        this.removeFromMap(tx.getTid());
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeFromMap(tx.getTid());
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr("name", "TransactionManager"), TransactionManagerFactory.class.getName(), null);
    }

    static {
        jtaTransactionsAreSerialByDefault = false;
    }
}

