/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.jmx;

import com.atomikos.icatch.admin.AdminTransaction;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.jmx.JmxLogAdministrator;
import com.atomikos.icatch.admin.jmx.JmxTransactionMBean;
import com.atomikos.icatch.admin.jmx.JmxTransactionMBeanFactory;
import com.atomikos.icatch.admin.jmx.JmxTransactionServiceMBean;
import com.atomikos.icatch.config.Configuration;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JmxTransactionService
implements JmxTransactionServiceMBean,
MBeanRegistration {
    private MBeanServer server;
    private ObjectName[] beans;
    private boolean heuristicsOnly;

    private synchronized void unregisterBeans() {
        try {
            if (this.beans != null) {
                for (int i = 0; i < this.beans.length; ++i) {
                    if (!this.server.isRegistered(this.beans[i])) continue;
                    this.server.unregisterMBean(this.beans[i]);
                }
            }
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (MBeanRegistrationException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.beans = null;
    }

    @Override
    public synchronized ObjectName[] getTransactions() {
        this.unregisterBeans();
        LogControl logControl = JmxLogAdministrator.getInstance().getLogControl();
        if (logControl == null) {
            throw new RuntimeException("LogControl is null: transaction service not running?");
        }
        AdminTransaction[] transactions = logControl.getAdminTransactions();
        JmxTransactionMBean[] mBeans = JmxTransactionMBeanFactory.createMBeans(transactions, this.heuristicsOnly);
        this.beans = new ObjectName[mBeans.length];
        for (int i = 0; i < mBeans.length; ++i) {
            try {
                this.beans[i] = new ObjectName("atomikos.transactions", "TID", mBeans[i].getTid());
                this.server.registerMBean(mBeans[i], this.beans[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return this.beans;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        JmxLogAdministrator admin = JmxLogAdministrator.getInstance();
        Configuration.addLogAdministrator((LogAdministrator)admin);
        if (name == null) {
            name = new ObjectName("atomikos", "name", "TransactionService");
        }
        return name;
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public void preDeregister() throws Exception {
        this.unregisterBeans();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void setHeuristicsOnly(boolean heuristicsOnly) {
        this.heuristicsOnly = heuristicsOnly;
    }

    @Override
    public boolean getHeuristicsOnly() {
        return this.heuristicsOnly;
    }
}

