/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.AbstractCompositeTransaction;
import com.atomikos.icatch.imp.CompositeTerminatorImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ExtentImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.icatch.imp.TxActiveStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Stack;

public class CompositeTransactionImp
extends AbstractCompositeTransaction
implements TransactionControl,
FSMEnterListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(CompositeTransactionImp.class);
    protected CoordinatorImp coordinator = null;
    protected TransactionServiceImp txservice;
    protected Extent extent = null;
    protected boolean noLocalAncestors;
    private TransactionStateHandler stateHandler;

    CompositeTransactionImp(Stack lineage, String tid, boolean serial, CoordinatorImp coordinator) {
        this(null, lineage, tid, serial, coordinator);
    }

    public CompositeTransactionImp(TransactionServiceImp txservice, Stack lineage, String tid, boolean serial, CoordinatorImp coordinator) throws IllegalStateException {
        super(tid, lineage, serial);
        this.coordinator = coordinator;
        this.txservice = txservice;
        this.extent = null;
        this.noLocalAncestors = true;
        this.stateHandler = new TxActiveStateHandler(this);
        coordinator.addFSMEnterListener(this, TxState.TERMINATED);
    }

    synchronized void localSetTransactionStateHandler(TransactionStateHandler handler) {
        this.stateHandler = handler;
    }

    synchronized void localTestAndSetTransactionStateHandler(TransactionStateHandler expected, TransactionStateHandler newHandler) {
        if (this.stateHandler != expected) {
            throw new IllegalStateException("State is no longer " + expected.getState() + " but " + newHandler.getState());
        }
        this.localSetTransactionStateHandler(newHandler);
    }

    synchronized TransactionStateHandler localGetTransactionStateHandler() {
        return this.stateHandler;
    }

    boolean isLocalRoot() {
        return this.noLocalAncestors;
    }

    TransactionServiceImp getTransactionService() {
        return this.txservice;
    }

    CoordinatorImp getCoordinatorImp() {
        return this.coordinator;
    }

    @Override
    public TransactionControl getTransactionControl() {
        return this;
    }

    @Override
    public int getLocalSubTxCount() {
        return this.localGetTransactionStateHandler().getSubTransactionCount();
    }

    @Override
    public synchronized void setSerial() throws IllegalStateException, SysException {
        if (!this.isRoot()) {
            throw new IllegalStateException("Not a root tx.");
        }
        this.serial_ = true;
    }

    @Override
    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction ret = this.localGetTransactionStateHandler().createSubTransaction();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("createSubTransaction(): created new SUBTRANSACTION " + ret.getTid() + " for existing transaction " + this.getTid());
        }
        return ret;
    }

    @Override
    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        RecoveryCoordinator ret = this.localGetTransactionStateHandler().addParticipant(participant);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("addParticipant ( " + participant + " ) for transaction " + this.getTid());
        }
        return ret;
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws IllegalStateException, UnsupportedOperationException, SysException {
        this.localGetTransactionStateHandler().registerSynchronization(sync);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("registerSynchronization ( " + sync + " ) for transaction " + this.getTid());
        }
    }

    @Override
    public void addSubTxAwareParticipant(SubTxAwareParticipant subtxaware) throws SysException, IllegalStateException {
        this.localGetTransactionStateHandler().addSubTxAwareParticipant(subtxaware);
    }

    protected void doRollback() throws IllegalStateException, SysException {
        this.localGetTransactionStateHandler().rollbackWithStateCheck();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("rollback() done of transaction " + this.getTid());
        }
    }

    @Override
    public CompositeCoordinator getCompositeCoordinator() throws SysException {
        return this.coordinator;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public CompositeTerminator getTerminator() {
        return new CompositeTerminatorImp((TransactionService)this.txservice, this, this.coordinator);
    }

    protected void doCommit() throws SysException, IllegalStateException, RollbackException {
        this.localGetTransactionStateHandler().commit();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("commit() done (by application) of transaction " + this.getTid());
        }
    }

    @Override
    public long getTimeout() {
        return this.coordinator.getTimeOut();
    }

    @Override
    public synchronized Extent getExtent() {
        if (this.extent == null) {
            this.extent = new ExtentImp();
        }
        return this.extent;
    }

    @Override
    public void setRollbackOnly() {
        this.localGetTransactionStateHandler().setRollbackOnly();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("setRollbackOnly() called for transaction " + this.getTid());
        }
    }

    @Override
    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        this.getTerminator().commit();
    }

    @Override
    public void rollback() throws IllegalStateException, SysException {
        this.getTerminator().rollback();
    }

    @Override
    public TxState getState() {
        return this.localGetTransactionStateHandler().getState();
    }

    public void entered(FSMEnterEvent coordinatorTerminatedEvent) {
        if (this.getState().equals((Object)TxState.ACTIVE) || this.getState().equals((Object)TxState.MARKED_ABORT)) {
            try {
                boolean recoverableWhileActive = false;
                Boolean pref = this.coordinator.isRecoverableWhileActive();
                if (pref != null) {
                    recoverableWhileActive = pref;
                }
                if (!recoverableWhileActive && !(this.stateHandler instanceof TxTerminatedStateHandler)) {
                    this.setRollbackOnly();
                } else {
                    this.rollback();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.logDebug("Ignoring error during event callback", (Throwable)e);
            }
        }
    }
}

