/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CompositeTransactionManagerImp
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(CompositeTransactionManagerImp.class);
    private static final long serialVersionUID = -552994279460833505L;
    private Map<Thread, Stack<CompositeTransaction>> threadtotxmap_ = new HashMap<Thread, Stack<CompositeTransaction>>();
    private Map<CompositeTransaction, Thread> txtothreadmap_ = new HashMap<CompositeTransaction, Thread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction ct) {
        Thread thread = null;
        Map<CompositeTransaction, Thread> map = this.txtothreadmap_;
        synchronized (map) {
            thread = this.txtothreadmap_.get(ct);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack removeThreadMappings(Thread thread) {
        Stack<CompositeTransaction> ret = null;
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            ret = this.threadtotxmap_.remove(thread);
            CompositeTransaction tx = ret.peek();
            this.txtothreadmap_.remove(tx);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction ct, Thread thread) throws IllegalStateException, SysException {
        ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            if (TxState.ACTIVE.equals((Object)ct.getState())) {
                Stack<Object> txs = this.threadtotxmap_.get(thread);
                if (txs == null) {
                    txs = new Stack();
                }
                txs.push(ct);
                this.threadtotxmap_.put(thread, txs);
                this.txtothreadmap_.put(ct, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack stack, Thread thread) throws IllegalStateException {
        CompositeTransaction tx = (CompositeTransaction)stack.peek();
        tx.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            TxState state = tx.getState();
            if (TxState.ACTIVE.equals((Object)state) || TxState.MARKED_ABORT.equals((Object)state)) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
                if (txs != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(tx, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransactionImp getCurrentTx() {
        Thread thread = Thread.currentThread();
        Map<Thread, Stack<CompositeTransaction>> map = this.threadtotxmap_;
        synchronized (map) {
            Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread);
            if (txs == null) {
                return null;
            }
            return (CompositeTransactionImp)txs.peek();
        }
    }

    public Participant getParticipant(String root) {
        return this.getTransactionService().getParticipant(root);
    }

    private TransactionService getTransactionService() {
        TransactionService ret = Configuration.getTransactionService();
        if (ret == null) {
            throw new IllegalStateException("Not initialized");
        }
        return ret;
    }

    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public CompositeTransaction getCompositeTransaction() throws SysException {
        CompositeTransactionImp ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("getCompositeTransaction()  returning instance with id " + ct.getTid());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("getCompositeTransaction() returning NULL!");
        }
        return ct;
    }

    public CompositeTransaction getCompositeTransaction(String tid) throws SysException {
        CompositeTransaction ret = this.getTransactionService().getCompositeTransaction(tid);
        if (ret != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("getCompositeTransaction ( " + tid + " ) returning instance with tid " + ret.getTid());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("getCompositeTransaction ( " + tid + " ) returning null");
        }
        return ret;
    }

    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context, boolean orphancheck, boolean heur_commit) throws SysException {
        CompositeTransactionImp ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            LOGGER.logWarning("Recreating a transaction with existing transaction: " + ct.getTid());
        }
        ct = this.getTransactionService().recreateCompositeTransaction(context, orphancheck, heur_commit);
        Thread t = Thread.currentThread();
        this.setThreadMappings(ct, t);
        return ct;
    }

    public CompositeTransaction suspend() throws SysException {
        CompositeTransactionImp ret = this.getCurrentTx();
        if (ret != null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("suspend() for transaction " + ret.getTid());
            }
            Thread thread = Thread.currentThread();
            this.removeThreadMappings(thread);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("suspend() called without a transaction context");
        }
        return ret;
    }

    public void resume(CompositeTransaction ct) throws IllegalStateException, SysException {
        Stack ancestors = new Stack();
        Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
        Stack lineage = (Stack)ct.getLineage().clone();
        boolean done = false;
        while (!lineage.isEmpty() && !done) {
            CompositeTransaction parent = (CompositeTransaction)lineage.pop();
            if (!parent.isLocal()) {
                done = true;
                continue;
            }
            tmp.push(parent);
        }
        while (!tmp.isEmpty()) {
            ancestors.push(tmp.pop());
        }
        ancestors.push(ct);
        Thread thread = Thread.currentThread();
        this.restoreThreadMappings(ancestors, thread);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("resume ( " + ct + " ) done for transaction " + ct.getTid());
        }
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.getTransactionService().shutdown(force);
    }

    protected void startlistening(CompositeTransaction transaction) throws SysException {
        transaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        Thread thread = this.getThread(ct);
        if (thread == null) {
            return;
        }
        Stack mappings = this.removeThreadMappings(thread);
        if (mappings != null && !mappings.empty()) {
            mappings.pop();
            if (!mappings.empty()) {
                this.restoreThreadMappings(mappings, thread);
            }
        }
    }

    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        Stack errors = new Stack();
        CompositeTransactionImp ct = null;
        CompositeTransaction ret = null;
        ct = this.getCurrentTx();
        if (ct == null) {
            ret = this.getTransactionService().createCompositeTransaction(timeout);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("createCompositeTransaction ( " + timeout + " ): " + "created new ROOT transaction with id " + ret.getTid());
            }
        } else {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.logInfo("createCompositeTransaction ( " + timeout + " )");
            }
            ret = ct.getTransactionControl().createSubTransaction();
        }
        Thread thread = Thread.currentThread();
        this.setThreadMappings(ret, thread);
        return ret;
    }
}

