/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMImp;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.finitestates.Stateful;
import com.atomikos.finitestates.TransitionTable;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.transaction.TransactionAbortedEvent;
import com.atomikos.icatch.event.transaction.TransactionCommittedEvent;
import com.atomikos.icatch.event.transaction.TransactionCreatedEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.icatch.event.transaction.TransactionReadOnlyEvent;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CoordinatorLogImage;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.HeurHazardStateHandler;
import com.atomikos.icatch.imp.RollbackOnlyParticipant;
import com.atomikos.icatch.imp.TransactionTransitionTable;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.publish.EventPublisher;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Vector;

public class CoordinatorImp
implements CompositeCoordinator,
Participant,
RecoveryCoordinator,
StateRecoverable<TxState>,
AlarmTimerListener,
Stateful<TxState>,
FSMPreEnterListener<TxState>,
FSMTransitionListener<TxState>,
FSMEnterListener<TxState> {
    private static final Logger LOGGER = LoggerFactory.createLogger(CoordinatorImp.class);
    static long DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS = 150L;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_FOR_INDOUBTS = 30;
    private static final int MAX_NUMBER_OF_TIMEOUT_TICKS_BEFORE_ROLLBACK_OF_ACTIVES = 30;
    private int localSiblingCount_ = 0;
    private AlarmTimer timer_ = null;
    private boolean checkSiblings_ = true;
    private long maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = 30L;
    private long maxNumberOfTimeoutTicksBeforeRollback_ = 30L;
    private String root_ = null;
    private FSM<TxState> fsm_ = null;
    private boolean recoverableWhileActive_;
    private boolean heuristicMeansCommit_ = true;
    private Vector<Participant> participants_ = new Vector();
    private RecoveryCoordinator superiorCoordinator_ = null;
    private Vector<HeuristicMessage> tags_ = new Vector();
    private CoordinatorStateHandler stateHandler_;
    private boolean single_threaded_2pc_;
    private transient List<Synchronization> synchronizations;

    protected CoordinatorImp(String root, boolean heuristic_commit, boolean checkorphans) {
        this.root_ = root;
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = heuristic_commit;
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.checkSiblings_ = checkorphans;
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    private void initFsm(TxState initialState) {
        this.fsm_ = new FSMImp((Object)this, (TransitionTable)new TransactionTransitionTable(), (Object)initialState);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.TERMINATED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_MIXED);
        this.fsm_.addFSMPreEnterListener((FSMPreEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.fsm_.addFSMTransitionListener((FSMTransitionListener)this, (Object)TxState.COMMITTING, (Object)TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener((FSMTransitionListener)this, (Object)TxState.ABORTING, (Object)TxState.TERMINATED);
        this.fsm_.addFSMTransitionListener((FSMTransitionListener)this, (Object)TxState.PREPARING, (Object)TxState.TERMINATED);
        this.fsm_.addFSMEnterListener((FSMEnterListener)this, (Object)TxState.HEUR_COMMITTED);
        this.fsm_.addFSMEnterListener((FSMEnterListener)this, (Object)TxState.HEUR_ABORTED);
        this.fsm_.addFSMEnterListener((FSMEnterListener)this, (Object)TxState.HEUR_HAZARD);
        this.fsm_.addFSMEnterListener((FSMEnterListener)this, (Object)TxState.HEUR_MIXED);
    }

    protected CoordinatorImp(String root, RecoveryCoordinator coord, boolean heuristic_commit, long timeout, boolean checkorphans, boolean single_threaded_2pc) {
        this.root_ = root;
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = heuristic_commit;
        this.recoverableWhileActive_ = false;
        this.superiorCoordinator_ = coord;
        if (timeout > DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS) {
            this.maxNumberOfTimeoutTicksBeforeRollback_ = this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = timeout / DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
        }
        this.setStateHandler(new ActiveStateHandler(this));
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        this.checkSiblings_ = checkorphans;
        this.synchronizations = new ArrayList<Synchronization>();
        this.publishDomainEvent((Event)new TransactionCreatedEvent(this.root_));
    }

    public CoordinatorImp(String root, RecoveryCoordinator coord, boolean heuristic_commit, boolean checkorphans) {
        this(root, coord, heuristic_commit, DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS, checkorphans, false);
    }

    public CoordinatorImp() {
        this.initFsm(TxState.ACTIVE);
        this.heuristicMeansCommit_ = false;
        this.checkSiblings_ = true;
        this.recoverableWhileActive_ = false;
        this.single_threaded_2pc_ = false;
        this.synchronizations = new ArrayList<Synchronization>();
    }

    boolean prefersSingleThreaded2PC() {
        return this.single_threaded_2pc_;
    }

    void setCommitted() {
        this.stateHandler_.setCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTag(HeuristicMessage tag) {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (tag != null) {
                this.tags_.addElement(tag);
            }
        }
    }

    void setStateHandler(CoordinatorStateHandler stateHandler) {
        TxState state = stateHandler.getState();
        this.stateHandler_ = stateHandler;
        this.setState(state);
    }

    RecoveryCoordinator getSuperiorRecoveryCoordinator() {
        return this.superiorCoordinator_;
    }

    Vector<Participant> getParticipants() {
        return this.participants_;
    }

    boolean prefersHeuristicCommit() {
        return this.heuristicMeansCommit_;
    }

    int getLocalSiblingCount() {
        return this.localSiblingCount_;
    }

    long getMaxIndoubtTicks() {
        return this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_;
    }

    long getMaxRollbackTicks() {
        return this.maxNumberOfTimeoutTicksBeforeRollback_;
    }

    boolean checkSiblings() {
        return this.checkSiblings_;
    }

    public Boolean isRecoverableWhileActive() {
        return new Boolean(this.recoverableWhileActive_);
    }

    public HeuristicMessage[] getHeuristicMessages(Object heuristicState) {
        return this.stateHandler_.getHeuristicMessages(heuristicState);
    }

    public boolean isCommitted() {
        return this.stateHandler_.isCommitted();
    }

    public HeuristicMessage[] getHeuristicMessages() {
        return this.stateHandler_.getHeuristicMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] getTags() {
        HeuristicMessage[] template = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            template = new HeuristicMessage[this.tags_.size()];
            for (int i = 0; i < template.length; ++i) {
                template[i] = this.tags_.elementAt(i);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startThreads(long timeout) {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ == null) {
                this.stateHandler_.activate();
                this.timer_ = new PooledAlarmTimer(timeout);
                this.timer_.addAlarmTimerListener((AlarmTimerListener)this);
                this.submitTimer(this.timer_);
            }
        }
    }

    private void submitTimer(AlarmTimer timer) {
        TaskManager.getInstance().executeTask((Runnable)timer);
    }

    protected long getTimeOut() {
        return (this.maxNumberOfTimeoutTicksBeforeRollback_ - this.stateHandler_.getRollbackTicks()) * DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS;
    }

    void setState(TxState state) throws IllegalStateException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("Coordinator " + this.getCoordinatorId() + " entering state: " + state.toString());
        }
        this.fsm_.setState((Object)state);
    }

    public TxState getState() {
        return (TxState)this.fsm_.getState();
    }

    public void addFSMEnterListener(FSMEnterListener l, TxState state) {
        this.fsm_.addFSMEnterListener(l, (Object)state);
    }

    public void addFSMPreEnterListener(FSMPreEnterListener l, TxState state) {
        this.fsm_.addFSMPreEnterListener(l, (Object)state);
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        return this;
    }

    public Participant getParticipant() throws UnsupportedOperationException {
        return this;
    }

    public String getCoordinatorId() {
        return this.root_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException, RollbackException {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException(this.getCoordinatorId() + " is no longer active but in state " + this.getState().toString());
            }
            if (!this.participants_.contains(participant)) {
                this.participants_.add(participant);
            }
            this.setState(TxState.ACTIVE);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incLocalSiblingCount() {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ++this.localSiblingCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, UnsupportedOperationException, SysException {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (!this.getState().equals((Object)TxState.ACTIVE)) {
                throw new IllegalStateException("wrong state: " + this.getState());
            }
            this.rememberSychronizationForAfterCompletion(sync);
        }
    }

    private void rememberSychronizationForAfterCompletion(Synchronization sync) {
        this.getSynchronizations().add(sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Synchronization> getSynchronizations() {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (this.synchronizations == null) {
                this.synchronizations = new ArrayList<Synchronization>();
            }
            return this.synchronizations;
        }
    }

    void notifySynchronizationsAfterCompletion(TxState ... successiveStates) {
        for (TxState state : successiveStates) {
            for (Synchronization s : this.getSynchronizations()) {
                try {
                    s.afterCompletion((Object)state);
                }
                catch (Throwable t) {
                    LOGGER.logWarning("Unexpected error in afterCompletion", t);
                }
            }
        }
    }

    public void preEnter(FSMEnterEvent<TxState> event) throws IllegalStateException {
        TxState state = (TxState)event.getState();
        if (state.equals((Object)TxState.TERMINATED) || state.equals((Object)TxState.HEUR_ABORTED) || state.equals((Object)TxState.HEUR_COMMITTED) || state.equals((Object)TxState.HEUR_HAZARD) || state.equals((Object)TxState.HEUR_MIXED)) {
            if (!state.equals((Object)TxState.TERMINATED)) {
                LOGGER.logWarning("Local heuristic termination of coordinator " + this.root_ + " with state " + this.getState());
            } else {
                this.dispose();
            }
        }
    }

    public String getURI() {
        return this.getCoordinatorId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws SysException {
        boolean ret;
        boolean allOK = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("starting recover() for coordinator: " + this.getCoordinatorId());
        }
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            for (Participant next : this.getParticipants()) {
                boolean recoveredParticipant;
                block9: {
                    recoveredParticipant = false;
                    try {
                        recoveredParticipant = next.recover();
                        if (!LOGGER.isDebugEnabled()) break block9;
                        LOGGER.logDebug("coordinator: " + this.getCoordinatorId() + "recovered participant: " + next);
                    }
                    catch (Exception e) {
                        LOGGER.logWarning("Error in recovering participant");
                        StackTraceElement[] infos = e.getStackTrace();
                        for (int i = 0; i < infos.length; ++i) {
                            LOGGER.logWarning(infos[i].toString());
                        }
                    }
                }
                allOK = allOK && recoveredParticipant;
            }
            this.stateHandler_.recover(this);
            ret = allOK || !this.getState().equals((Object)TxState.IN_DOUBT);
        }
        this.startThreads(DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("recover() done for coordinator: " + this.getCoordinatorId());
        }
        return ret;
    }

    public void forget() {
        this.stateHandler_.forget();
    }

    public void setCascadeList(Dictionary allParticipants) throws SysException {
        this.stateHandler_.setCascadeList(allParticipants);
    }

    public void setGlobalSiblingCount(int count) {
        this.stateHandler_.setGlobalSiblingCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        if (this.getState().equals((Object)TxState.PREPARING)) {
            throw new RollbackException("Recursion detected");
        }
        int ret = 1;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.prepare();
            if (ret == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("prepare() of Coordinator  " + this.getCoordinatorId() + " returning READONLY");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("prepare() of Coordinator  " + this.getCoordinatorId() + " returning YES vote");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        HeuristicMessage[] ret = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.commit(onePhase);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        HeuristicMessage[] ret = null;
        if (this.getState().equals((Object)TxState.ABORTING)) {
            return this.getHeuristicMessages();
        }
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.rollback();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] rollbackHeuristically() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        HeuristicMessage[] ret = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.rollbackHeuristically();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeuristicMessage[] commitHeuristically() throws HeurMixedException, SysException, HeurRollbackException, HeurHazardException, IllegalStateException, RollbackException {
        HeuristicMessage[] ret = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.commitHeuristically();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean replayCompletion(Participant participant) throws IllegalStateException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("replayCompletion ( " + participant + " ) received by coordinator " + this.getCoordinatorId() + " for participant " + participant.toString());
        }
        Boolean ret = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            ret = this.stateHandler_.replayCompletion(participant);
        }
        return ret;
    }

    protected void restore(ObjectImage image) {
        CoordinatorLogImage img = (CoordinatorLogImage)image;
        this.root_ = img.root_;
        this.participants_ = img.participants_;
        this.superiorCoordinator_ = img.coordinator_;
        this.heuristicMeansCommit_ = img.heuristicCommit_;
        this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_ = img.maxInquiries_;
        this.maxNumberOfTimeoutTicksBeforeRollback_ = img.maxInquiries_;
        this.recoverableWhileActive_ = img.activity_;
        if (this.recoverableWhileActive_) {
            this.checkSiblings_ = img.checkSiblings_;
            this.localSiblingCount_ = img.localSiblingCount_;
        }
        this.initFsm(img.state_);
        this.stateHandler_ = img.stateHandler_;
        if (img.state_.equals((Object)TxState.COMMITTING) && this.stateHandler_.getState().equals((Object)TxState.ACTIVE)) {
            HeurHazardStateHandler stateHandler = new HeurHazardStateHandler(this.stateHandler_, img.participants_);
            ((CoordinatorStateHandler)stateHandler).recover(this);
            this.setStateHandler(stateHandler);
        }
        this.single_threaded_2pc_ = img.single_threaded_2pc_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectImage getObjectImage() {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            return this.getObjectImage(this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectImage getObjectImage(TxState state) {
        CoordinatorLogImage ret = null;
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (this.excludedFromLogging(state)) {
                ret = null;
            } else {
                TxState imgstate = state;
                ret = this.recoverableWhileActive_ ? new CoordinatorLogImage(this.root_, imgstate, this.participants_, this.superiorCoordinator_, this.heuristicMeansCommit_, this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_, this.stateHandler_, this.localSiblingCount_, this.checkSiblings_, this.single_threaded_2pc_) : new CoordinatorLogImage(this.root_, imgstate, this.participants_, this.superiorCoordinator_, this.heuristicMeansCommit_, this.maxNumberOfTimeoutTicksBeforeHeuristicDecision_, this.stateHandler_, this.single_threaded_2pc_);
            }
        }
        return ret;
    }

    private boolean excludedFromLogging(Object state) {
        boolean ret = false;
        if (state.equals(TxState.ACTIVE) && !this.recoverableWhileActive_) {
            ret = true;
        } else if (this.superiorCoordinator_ == null) {
            if (state.equals(TxState.IN_DOUBT)) {
                ret = true;
            } else if (this.participants_.size() == 0) {
                ret = true;
            }
        }
        return ret;
    }

    public TxState[] getRecoverableStates() {
        return new TxState[]{TxState.ACTIVE, TxState.IN_DOUBT, TxState.COMMITTING, TxState.HEUR_COMMITTED, TxState.HEUR_ABORTED, TxState.HEUR_HAZARD, TxState.HEUR_MIXED};
    }

    public TxState[] getFinalStates() {
        return new TxState[]{TxState.TERMINATED};
    }

    public Object getId() {
        return this.root_;
    }

    public void alarm(AlarmTimer timer) {
        try {
            this.stateHandler_.onTimeout();
        }
        catch (Exception e) {
            LOGGER.logWarning("Exception on timeout of coordinator " + this.root_, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (this.timer_ != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("Coordinator " + this.getCoordinatorId() + " : stopping timer...");
                }
                this.timer_.stop();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Coordinator " + this.getCoordinatorId() + " : disposing statehandler " + this.stateHandler_.getState() + "...");
            }
            this.stateHandler_.dispose();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Coordinator " + this.getCoordinatorId() + " : disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminate(boolean commit) throws HeurRollbackException, HeurMixedException, SysException, SecurityException, HeurCommitException, HeurHazardException, RollbackException, IllegalStateException {
        FSM<TxState> fSM = this.fsm_;
        synchronized (fSM) {
            if (commit) {
                if (this.participants_.size() <= 1) {
                    this.commit(true);
                } else {
                    int prepareResult = this.prepare();
                    if (prepareResult != 0) {
                        this.commit(false);
                    }
                }
            } else {
                this.rollback();
            }
        }
    }

    public void setRecoverableWhileActive() throws UnsupportedOperationException {
        this.recoverableWhileActive_ = true;
    }

    void setRollbackOnly() {
        block4: {
            StringHeuristicMessage msg = new StringHeuristicMessage("setRollbackOnly");
            RollbackOnlyParticipant p = new RollbackOnlyParticipant(msg);
            try {
                this.addParticipant(p);
            }
            catch (IllegalStateException alreadyTerminated) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("Error during setRollbackOnly", (Throwable)alreadyTerminated);
                }
            }
            catch (RollbackException e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.logDebug("Error during setRollbackOnly", (Throwable)e);
            }
        }
    }

    public TxState getStateWithTwoPhaseCommitDecision() {
        TxState ret = this.getState();
        if (TxState.TERMINATED.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTED : TxState.ABORTED;
        } else if (TxState.HEUR_ABORTED.equals((Object)this.getState())) {
            ret = TxState.ABORTED;
        } else if (TxState.HEUR_COMMITTED.equals((Object)this.getState())) {
            ret = TxState.COMMITTED;
        } else if (TxState.HEUR_HAZARD.equals((Object)this.getState())) {
            ret = this.isCommitted() ? TxState.COMMITTING : TxState.ABORTING;
        }
        return ret;
    }

    public void transitionPerformed(FSMTransitionEvent<TxState> e) {
        TxState fromState = (TxState)e.fromState();
        TxState toState = (TxState)e.toState();
        if (TxState.TERMINATED.equals((Object)toState)) {
            if (TxState.COMMITTING.equals((Object)fromState)) {
                this.publishDomainEvent((Event)new TransactionCommittedEvent(this.root_));
            } else if (TxState.ABORTING.equals((Object)fromState)) {
                this.publishDomainEvent((Event)new TransactionAbortedEvent(this.root_));
            } else if (TxState.PREPARING.equals((Object)fromState)) {
                this.publishDomainEvent((Event)new TransactionReadOnlyEvent(this.root_));
            }
        }
    }

    private void publishDomainEvent(Event event) {
        EventPublisher.publish((Event)event);
    }

    public void entered(FSMEnterEvent<TxState> e) {
        TxState state = (TxState)e.getState();
        if (TxState.HEUR_ABORTED.equals((Object)state) || TxState.HEUR_COMMITTED.equals((Object)state) || TxState.HEUR_HAZARD.equals((Object)state) || TxState.HEUR_MIXED.equals((Object)state)) {
            this.publishDomainEvent((Event)new TransactionHeuristicEvent(this.root_));
        }
    }
}

