/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.LogControlImp;
import com.atomikos.icatch.provider.TransactionServicePlugin;
import com.atomikos.icatch.provider.TransactionServiceProvider;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.thread.InterruptedExceptionHelper;
import com.atomikos.thread.TaskManager;
import com.atomikos.util.UniqueIdMgr;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class TransactionServiceImp
implements TransactionServiceProvider,
FSMEnterListener<TxState>,
SubTxAwareParticipant,
RecoveryService {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionServiceImp.class);
    private static final int NUMLATCHES = 97;
    private long maxTimeout_;
    private Object[] rootLatches_ = null;
    private Hashtable tidToTransactionMap_ = null;
    private Hashtable rootToCoordinatorMap_ = null;
    private boolean shutdownInProgress_ = false;
    private Object shutdownSynchronizer_;
    private Object recoverySynchronizer_;
    private UniqueIdMgr tidmgr_ = null;
    private StateRecoveryManager recoverymanager_ = null;
    private boolean initialized_ = false;
    private LogControl control_;
    private boolean otsOverride_;
    private Vector tsListeners_;
    private int maxNumberOfActiveTransactions_;
    private String tmUniqueName_;
    private Properties initProperties_;
    private boolean single_threaded_2pc_;

    public TransactionServiceImp(String name, StateRecoveryManager recoverymanager, UniqueIdMgr tidmgr, long maxtimeout, int maxActives, boolean single_threaded_2pc) {
        this(name, recoverymanager, tidmgr, maxtimeout, true, maxActives, single_threaded_2pc);
    }

    public TransactionServiceImp(String name, StateRecoveryManager recoverymanager, UniqueIdMgr tidmgr, long maxtimeout, boolean checkorphans, int maxActives, boolean single_threaded_2pc) {
        this.maxNumberOfActiveTransactions_ = maxActives;
        this.otsOverride_ = !checkorphans;
        this.initialized_ = false;
        this.recoverymanager_ = recoverymanager;
        this.tidmgr_ = tidmgr;
        this.tidToTransactionMap_ = new Hashtable();
        this.shutdownSynchronizer_ = new Object();
        this.recoverySynchronizer_ = new Object();
        this.rootToCoordinatorMap_ = new Hashtable();
        this.rootLatches_ = new Object[97];
        for (int i = 0; i < 97; ++i) {
            this.rootLatches_[i] = new Object();
        }
        this.maxTimeout_ = maxtimeout;
        this.tmUniqueName_ = name;
        this.tsListeners_ = new Vector();
        this.single_threaded_2pc_ = single_threaded_2pc;
    }

    protected Object getLatch(String root) {
        return this.rootLatches_[Math.abs(root.toString().hashCode() % 97)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTidToTx(String tid, CompositeTransaction ct) throws IllegalStateException {
        Hashtable hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            if (this.tidToTransactionMap_.containsKey(tid.intern())) {
                throw new IllegalStateException("Already mapped: " + tid);
            }
            this.tidToTransactionMap_.put(tid.intern(), ct);
            ct.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        }
    }

    Vector getCoordinatorImpVector() {
        Vector<CoordinatorImp> ret = new Vector<CoordinatorImp>();
        Enumeration tids = this.rootToCoordinatorMap_.keys();
        while (tids.hasMoreElements()) {
            String next = (String)tids.nextElement();
            CoordinatorImp c = this.getCoordinatorImp(next);
            if (c == null) continue;
            ret.addElement(c);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinator(CompositeCoordinator coord) {
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            Object object2 = this.getLatch(coord.getCoordinatorId().intern());
            synchronized (object2) {
                this.rootToCoordinatorMap_.remove(coord.getCoordinatorId().intern());
            }
            if (this.rootToCoordinatorMap_.isEmpty()) {
                this.shutdownSynchronizer_.notifyAll();
            }
        }
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        this.tidToTransactionMap_.remove(ct.getTid().intern());
    }

    private CompositeTransactionImp createCT(String tid, CoordinatorImp coordinator, Stack lineage, boolean serial) throws SysException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("Creating composite transaction: " + tid);
        }
        CompositeTransactionImp ct = new CompositeTransactionImp(this, lineage, tid, serial, coordinator);
        this.setTidToTx(ct.getTid(), ct);
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp createCC(RecoveryCoordinator adaptor, String root, boolean checkOrphans, boolean heuristic_commit, long timeout) {
        CoordinatorImp cc = null;
        if (timeout > this.maxTimeout_) {
            timeout = this.maxTimeout_;
            LOGGER.logWarning("Attempt to create a transaction with a timeout that exceeds maximum - truncating to: " + this.maxTimeout_);
        }
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            if (this.shutdownInProgress_) {
                throw new IllegalStateException("Server is shutting down...");
            }
            if (this.otsOverride_) {
                checkOrphans = false;
            }
            cc = new CoordinatorImp(root, adaptor, heuristic_commit, timeout, checkOrphans, this.single_threaded_2pc_);
            this.recoverymanager_.register(cc);
            Object object2 = this.getLatch(root.intern());
            synchronized (object2) {
                this.rootToCoordinatorMap_.put(root.intern(), cc);
            }
            this.startlistening(cc);
        }
        return cc;
    }

    private void startlistening(CoordinatorImp coordinator) {
        Hashtable<TxState, Object> forgetStates = new Hashtable<TxState, Object>();
        forgetStates.put(TxState.TERMINATED, new Object());
        TxState[] finalStates = coordinator.getFinalStates();
        for (int i = 0; i < finalStates.length; ++i) {
            forgetStates.put(finalStates[i], new Object());
        }
        Enumeration enumm = forgetStates.keys();
        while (enumm.hasMoreElements()) {
            TxState state = (TxState)enumm.nextElement();
            coordinator.addFSMEnterListener(this, state);
        }
        if (forgetStates.contains(coordinator.getState())) {
            this.removeCoordinator(coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp getCoordinatorImp(String root) throws SysException {
        root = root.intern();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CoordinatorImp cc = null;
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            Object object2 = this.getLatch(root);
            synchronized (object2) {
                cc = (CoordinatorImp)this.rootToCoordinatorMap_.get(root.intern());
                if (cc == null) {
                    try {
                        cc = (CoordinatorImp)this.recoverymanager_.recover(root);
                    }
                    catch (LogException le) {
                        throw new SysException("Error in getting coordinator: " + le.getMessage(), (Throwable)le);
                    }
                    if (cc != null) {
                        this.startlistening(cc);
                        this.rootToCoordinatorMap_.put(root.intern(), cc);
                    }
                }
            }
        }
        return cc;
    }

    protected String createTid() throws SysException {
        return this.tidmgr_.get();
    }

    protected StateRecoveryManager getStateRecoveryManager() {
        return this.recoverymanager_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void recoverCoordinators() throws SysException {
        try {
            Vector<StateRecoverable<TxState>> recovered = this.recoverymanager_.recover();
            Enumeration<StateRecoverable<TxState>> enumm = recovered.elements();
            while (enumm.hasMoreElements()) {
                CoordinatorImp coord = (CoordinatorImp)enumm.nextElement();
                Object object = this.getLatch(coord.getCoordinatorId().intern());
                synchronized (object) {
                    this.rootToCoordinatorMap_.put(coord.getCoordinatorId().intern(), coord);
                }
                this.startlistening(coord);
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in recoverCoordinators", (Throwable)e);
            throw new SysException("Error in recoverCoordinators: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return this.tmUniqueName_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        if (!this.initialized_) {
            this.initialized_ = true;
        }
        Object object = this.recoverySynchronizer_;
        synchronized (object) {
            try {
                Vector coordinators = this.getCoordinatorImpVector();
                for (CoordinatorImp coord : coordinators) {
                    try {
                        if (coord.recover() || !LOGGER.isInfoEnabled()) continue;
                        LOGGER.logInfo("Coordinator not recoverable: " + coord.getCoordinatorId());
                    }
                    catch (Exception e) {
                        LOGGER.logWarning("Coordinator not recoverable: " + coord.getCoordinatorId(), (Throwable)e);
                    }
                }
                Enumeration reslist = Configuration.getResources();
                while (reslist.hasMoreElements()) {
                    RecoverableResource res = (RecoverableResource)reslist.nextElement();
                    try {
                        res.endRecovery();
                    }
                    catch (Exception error) {
                        LOGGER.logWarning("ERROR IN RECOVERY", (Throwable)error);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.logWarning("Error in recover: " + e.getClass().getName() + e.getMessage(), (Throwable)e);
                throw new SysException("Error in recovering: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public LogControl getLogControl() {
        return this.control_;
    }

    public CompositeCoordinator getCompositeCoordinator(String root) throws SysException {
        return this.getCoordinatorImp(root);
    }

    public void addTSListener(TransactionServicePlugin listener) throws IllegalStateException {
        if (!this.tsListeners_.contains(listener)) {
            this.tsListeners_.addElement(listener);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("Added TSListener: " + listener);
            }
        }
    }

    public void removeTSListener(TransactionServicePlugin listener) {
        this.tsListeners_.removeElement(listener);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("Removed TSListener: " + listener);
        }
    }

    public synchronized void init(Properties properties) throws SysException {
        this.initProperties_ = properties;
        try {
            this.recoverymanager_.init(properties);
        }
        catch (LogException le) {
            throw new SysException("Error in init: " + le.getMessage(), (Throwable)le);
        }
        this.recoverCoordinators();
        this.shutdownInProgress_ = false;
        this.control_ = new LogControlImp(this);
        this.recover();
    }

    public Participant getParticipant(String root) throws SysException {
        return this.getCoordinatorImp(root);
    }

    public void entered(FSMEnterEvent<TxState> event) {
        CoordinatorImp cc = (CoordinatorImp)event.getSource();
        TxState state = (TxState)event.getState();
        this.removeCoordinator(cc);
    }

    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeTransaction getCompositeTransaction(String tid) {
        CompositeTransaction ret = null;
        Hashtable hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            ret = (CompositeTransaction)this.tidToTransactionMap_.get(tid.intern());
        }
        return ret;
    }

    CompositeTransaction createSubTransaction(CompositeTransaction parent) {
        CompositeTransactionImp ret = null;
        Stack lineage = (Stack)parent.getLineage().clone();
        lineage.push(parent);
        String tid = this.tidmgr_.get();
        CoordinatorImp ccParent = (CoordinatorImp)parent.getCompositeCoordinator();
        CoordinatorImp cc = this.createCC(null, tid, false, ccParent.prefersHeuristicCommit(), parent.getTimeout());
        if (ccParent.isRecoverableWhileActive() != null && ccParent.isRecoverableWhileActive().booleanValue()) {
            cc.setRecoverableWhileActive();
        }
        ret = this.createCT(tid, cc, lineage, parent.isSerial());
        ret.noLocalAncestors = false;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context, boolean orphancheck, boolean heur_commit) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        CoordinatorImp cc = null;
        CompositeTransactionImp ct = null;
        try {
            String tid = this.tidmgr_.get();
            boolean serial = context.isSerial();
            Stack lineage = context.getLineage();
            if (lineage.empty()) {
                throw new SysException("Empty lineage in propagation: empty lineage");
            }
            Stack tmp = new Stack();
            while (!lineage.empty()) {
                tmp.push(lineage.pop());
            }
            CompositeTransaction root = (CompositeTransaction)tmp.peek();
            while (!tmp.empty()) {
                lineage.push(tmp.pop());
            }
            CompositeTransaction parent = (CompositeTransaction)lineage.peek();
            Object object = this.shutdownSynchronizer_;
            synchronized (object) {
                Object object2 = this.getLatch(root.getTid());
                synchronized (object2) {
                    cc = this.getCoordinatorImp(root.getTid());
                    if (cc == null) {
                        RecoveryCoordinator coord = parent.getCompositeCoordinator().getRecoveryCoordinator();
                        cc = this.createCC(coord, root.getTid(), orphancheck, heur_commit, context.getTimeOut());
                    }
                    cc.incLocalSiblingCount();
                }
            }
            ct = this.createCT(tid, cc, lineage, serial);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SysException("Error in recreate.", (Throwable)e);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean force) throws SysException, IllegalStateException {
        boolean wasShuttingDown = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("Transaction Service: Entering shutdown ( " + force + " )...");
        }
        if (!wasShuttingDown && force) {
            Enumeration enumm = this.rootToCoordinatorMap_.keys();
            while (enumm.hasMoreElements()) {
                String tid = (String)enumm.nextElement();
                LOGGER.logDebug("Transaction Service: Stopping thread for root " + tid + "...");
                CoordinatorImp c = (CoordinatorImp)this.rootToCoordinatorMap_.get(tid);
                if (c != null) {
                    c.dispose();
                }
                LOGGER.logDebug("Transaction Service: Thread stopped.");
            }
        }
        Object object = this.shutdownSynchronizer_;
        synchronized (object) {
            LOGGER.logDebug("Transaction Service: Shutdown acquired lock on waiter.");
            wasShuttingDown = this.shutdownInProgress_;
            this.shutdownInProgress_ = true;
            while (!this.rootToCoordinatorMap_.isEmpty() && !force) {
                try {
                    LOGGER.logWarning("Transaction Service: Waiting for non-terminated coordinators...");
                    this.shutdownSynchronizer_.wait(this.maxTimeout_);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("Transaction Service: Purging coordinators for shutdown...");
                    }
                    Hashtable clone = (Hashtable)this.rootToCoordinatorMap_.clone();
                    Enumeration coordinatorIds = clone.keys();
                    while (coordinatorIds.hasMoreElements()) {
                        String id = (String)coordinatorIds.nextElement();
                        CoordinatorImp c = (CoordinatorImp)clone.get(id);
                        if (!TxState.TERMINATED.equals((Object)c.getState())) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.logDebug("Transaction Service: removing terminated coordinator: " + id);
                        }
                        this.rootToCoordinatorMap_.remove(id);
                    }
                }
                catch (InterruptedException inter) {
                    InterruptedExceptionHelper.handleInterruptedException((InterruptedException)inter);
                    throw new SysException("Error in shutdown: " + inter.getMessage(), (Throwable)inter);
                }
            }
            this.initialized_ = false;
            if (!wasShuttingDown) {
                try {
                    this.recoverymanager_.close();
                }
                catch (LogException le) {
                    le.printStackTrace();
                    throw new SysException("Error in shutdown: " + le.getMessage(), (Throwable)le);
                }
            }
        }
        this.shutdownSystemExecutors();
    }

    private void shutdownSystemExecutors() {
        TaskManager exec = TaskManager.getInstance();
        if (exec != null) {
            exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (!this.shutdownInProgress_ && this.initialized_) {
                this.shutdown(true);
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in GC of TransactionServiceImp", (Throwable)e);
        }
        finally {
            super.finalize();
        }
    }

    public RecoveryCoordinator getSuperiorRecoveryCoordinator(String root) {
        RecoveryCoordinator ret = null;
        CoordinatorImp c = this.getCoordinatorImp(root);
        if (c != null) {
            ret = c.getSuperiorRecoveryCoordinator();
        }
        return ret;
    }

    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        String tid = this.tidmgr_.get();
        Stack lineage = new Stack();
        CoordinatorImp cc = this.createCC(null, tid, true, false, timeout);
        CompositeTransactionImp ct = this.createCT(tid, cc, lineage, false);
        return ct;
    }

    public RecoveryService getRecoveryService() {
        return this;
    }
}

