/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.provider.imp;

import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionManagerImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.provider.Assembler;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.icatch.provider.TransactionServiceProvider;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateRecoveryManagerImp;
import com.atomikos.persistence.imp.VolatileStateRecoveryManager;
import com.atomikos.util.ClassLoadingHelper;
import com.atomikos.util.UniqueIdMgr;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;

public class AssemblerImp
implements Assembler {
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "transactions-defaults.properties";
    private static final String JTA_PROPERTIES_FILE_NAME = "jta.properties";
    private static final String TRANSACTIONS_PROPERTIES_FILE_NAME = "transactions.properties";
    private static final int MAX_TID_LENGTH = 64;
    private static Logger LOGGER = LoggerFactory.createLogger(AssemblerImp.class);

    private void loadPropertiesFromClasspath(Properties p, String fileName) {
        URL url = null;
        url = ClassLoadingHelper.loadResourceFromClasspath(this.getClass(), (String)fileName);
        if (url == null) {
            this.getClass().getClassLoader();
            url = ClassLoader.getSystemResource(fileName);
        }
        if (url != null) {
            this.loadPropertiesFromUrl(p, url);
        } else {
            LOGGER.logDebug("Could not find expected property file: " + fileName);
        }
    }

    private void loadPropertiesFromUrl(Properties p, URL url) {
        try {
            InputStream in = url.openStream();
            p.load(in);
            in.close();
            LOGGER.logInfo("Loaded " + url.toString());
        }
        catch (IOException e) {
            LOGGER.logDebug("Failed to load property file: " + url.toString(), (Throwable)e);
        }
    }

    public ConfigProperties initializeProperties() {
        Properties defaults = new Properties();
        this.loadPropertiesFromClasspath(defaults, DEFAULT_PROPERTIES_FILE_NAME);
        Properties transactionsProperties = new Properties(defaults);
        this.loadPropertiesFromClasspath(transactionsProperties, TRANSACTIONS_PROPERTIES_FILE_NAME);
        Properties jtaProperties = new Properties(transactionsProperties);
        this.loadPropertiesFromClasspath(jtaProperties, JTA_PROPERTIES_FILE_NAME);
        Properties customProperties = new Properties(jtaProperties);
        this.loadPropertiesFromCustomFilePath(customProperties);
        Properties finalProperties = new Properties(customProperties);
        return new ConfigProperties(finalProperties);
    }

    private void loadPropertiesFromCustomFilePath(Properties customProperties) {
        String customFilePath = System.getProperty("com.atomikos.icatch.file");
        if (customFilePath != null) {
            File file = new File(customFilePath);
            try {
                URL url = file.toURL();
                this.loadPropertiesFromUrl(customProperties, url);
            }
            catch (MalformedURLException e) {
                LOGGER.logWarning("File not found: " + customFilePath);
            }
        }
    }

    private void logProperties(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            LOGGER.logInfo("USING: " + name + " = " + properties.getProperty(name));
        }
    }

    public TransactionServiceProvider assembleTransactionService(ConfigProperties configProperties) {
        this.logProperties(configProperties.getCompletedProperties());
        String tmUniqueName = configProperties.getTmUniqueName();
        boolean enableLogging = configProperties.getEnableLogging();
        long maxTimeout = configProperties.getMaxTimeout();
        int maxActives = configProperties.getMaxActives();
        boolean threaded2pc = configProperties.getThreaded2pc();
        FSMPreEnterListener<TxState> recMgr = null;
        recMgr = enableLogging ? new StateRecoveryManagerImp() : new VolatileStateRecoveryManager();
        UniqueIdMgr idMgr = new UniqueIdMgr(tmUniqueName);
        int overflow = idMgr.getMaxIdLengthInBytes() - 64;
        if (overflow > 0) {
            String msg = "Value too long : " + tmUniqueName;
            LOGGER.logWarning(msg);
            throw new SysException(msg);
        }
        return new TransactionServiceImp(tmUniqueName, (StateRecoveryManager)recMgr, idMgr, maxTimeout, maxActives, !threaded2pc);
    }

    public CompositeTransactionManager assembleCompositeTransactionManager() {
        return new CompositeTransactionManagerImp();
    }
}

