/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.LogException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LogFileLock {
    private static Logger LOGGER = LoggerFactory.createLogger(LogFileLock.class);
    private File lockfileToPreventDoubleStartup_;
    private FileOutputStream lockfilestream_ = null;
    private FileLock lock_ = null;
    private String dir;
    private String fileName;

    public LogFileLock(String dir, String fileName) {
        this.dir = dir;
        this.fileName = fileName;
    }

    public void acquireLock() throws LogException {
        try {
            this.lockfileToPreventDoubleStartup_ = new File(this.dir + this.fileName + ".lck");
            this.lockfilestream_ = new FileOutputStream(this.lockfileToPreventDoubleStartup_);
            this.lock_ = this.lockfilestream_.getChannel().tryLock();
            this.lockfileToPreventDoubleStartup_.deleteOnExit();
        }
        catch (OverlappingFileLockException failedToGetLock) {
            this.lock_ = null;
        }
        catch (IOException failedToGetLock) {
            this.lock_ = null;
        }
        if (this.lock_ == null) {
            LOGGER.logWarning("ERROR: the specified log seems to be in use already. Make sure that no other instance is running, or kill any pending process if needed.");
            throw new LogException("Log already in use?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        try {
            if (this.lock_ != null) {
                this.lock_.release();
            }
            if (this.lockfilestream_ != null) {
                this.lockfilestream_.close();
            }
        }
        catch (IOException e) {
            LOGGER.logWarning("Error releasing file lock: " + e.getMessage());
        }
        finally {
            this.lock_ = null;
        }
        if (this.lockfileToPreventDoubleStartup_ != null) {
            this.lockfileToPreventDoubleStartup_.delete();
            this.lockfileToPreventDoubleStartup_ = null;
        }
    }
}

