/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt;

import com.auth0.jwt.JWTDecoder;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.auth0.jwt.exceptions.IncorrectClaimException;
import com.auth0.jwt.exceptions.InvalidClaimException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.MissingClaimException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.impl.ExpectedCheckHolder;
import com.auth0.jwt.impl.JWTParser;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;

public final class JWTVerifier
implements com.auth0.jwt.interfaces.JWTVerifier {
    private final Algorithm algorithm;
    final List<ExpectedCheckHolder> expectedChecks;
    private final JWTParser parser;

    JWTVerifier(Algorithm algorithm, List<ExpectedCheckHolder> expectedChecks) {
        this.algorithm = algorithm;
        this.expectedChecks = Collections.unmodifiableList(expectedChecks);
        this.parser = new JWTParser();
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new BaseVerification(algorithm);
    }

    @Override
    public DecodedJWT verify(String token) throws JWTVerificationException {
        JWTDecoder jwt = new JWTDecoder(this.parser, token);
        return this.verify(jwt);
    }

    @Override
    public DecodedJWT verify(DecodedJWT jwt) throws JWTVerificationException {
        this.verifyAlgorithm(jwt, this.algorithm);
        this.algorithm.verify(jwt);
        this.verifyClaims(jwt, this.expectedChecks);
        return jwt;
    }

    private void verifyAlgorithm(DecodedJWT jwt, Algorithm expectedAlgorithm) throws AlgorithmMismatchException {
        if (!expectedAlgorithm.getName().equals(jwt.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT jwt, List<ExpectedCheckHolder> expectedChecks) throws TokenExpiredException, InvalidClaimException {
        for (ExpectedCheckHolder expectedCheck : expectedChecks) {
            String claimName;
            Claim claim;
            boolean isValid = expectedCheck.verify(claim = jwt.getClaim(claimName = expectedCheck.getClaimName()), jwt);
            if (isValid) continue;
            throw new IncorrectClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName), claimName, claim);
        }
    }

    public static class BaseVerification
    implements Verification {
        private final Algorithm algorithm;
        private final List<ExpectedCheckHolder> expectedChecks;
        private long defaultLeeway;
        private final Map<String, Long> customLeeways;
        private boolean ignoreIssuedAt;
        private Clock clock;

        BaseVerification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.expectedChecks = new ArrayList<ExpectedCheckHolder>();
            this.customLeeways = new HashMap<String, Long>();
            this.defaultLeeway = 0L;
        }

        @Override
        public Verification withIssuer(String ... issuer) {
            List<String> value = this.isNullOrEmpty(issuer) ? null : Arrays.asList(issuer);
            this.addCheck("iss", (claim, decodedJWT) -> {
                if (this.verifyNull((Claim)claim, value)) {
                    return true;
                }
                if (value == null || !value.contains(claim.asString())) {
                    throw new IncorrectClaimException("The Claim 'iss' value doesn't match the required issuer.", "iss", (Claim)claim);
                }
                return true;
            });
            return this;
        }

        @Override
        public Verification withSubject(String subject) {
            this.addCheck("sub", (claim, decodedJWT) -> this.verifyNull((Claim)claim, subject) || subject.equals(claim.asString()));
            return this;
        }

        @Override
        public Verification withAudience(String ... audience) {
            List<String> value = this.isNullOrEmpty(audience) ? null : Arrays.asList(audience);
            this.addCheck("aud", (claim, decodedJWT) -> {
                if (this.verifyNull((Claim)claim, value)) {
                    return true;
                }
                if (!this.assertValidAudienceClaim(decodedJWT.getAudience(), value, true)) {
                    throw new IncorrectClaimException("The Claim 'aud' value doesn't contain the required audience.", "aud", (Claim)claim);
                }
                return true;
            });
            return this;
        }

        @Override
        public Verification withAnyOfAudience(String ... audience) {
            List<String> value = this.isNullOrEmpty(audience) ? null : Arrays.asList(audience);
            this.addCheck("aud", (claim, decodedJWT) -> {
                if (this.verifyNull((Claim)claim, value)) {
                    return true;
                }
                if (!this.assertValidAudienceClaim(decodedJWT.getAudience(), value, false)) {
                    throw new IncorrectClaimException("The Claim 'aud' value doesn't contain the required audience.", "aud", (Claim)claim);
                }
                return true;
            });
            return this;
        }

        @Override
        public Verification acceptLeeway(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.defaultLeeway = leeway;
            return this;
        }

        @Override
        public Verification acceptExpiresAt(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.customLeeways.put("exp", leeway);
            return this;
        }

        @Override
        public Verification acceptNotBefore(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.customLeeways.put("nbf", leeway);
            return this;
        }

        @Override
        public Verification acceptIssuedAt(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.customLeeways.put("iat", leeway);
            return this;
        }

        @Override
        public Verification ignoreIssuedAt() {
            this.ignoreIssuedAt = true;
            return this;
        }

        @Override
        public Verification withJWTId(String jwtId) {
            this.addCheck("jti", (claim, decodedJWT) -> this.verifyNull((Claim)claim, jwtId) || jwtId.equals(claim.asString()));
            return this;
        }

        @Override
        public Verification withClaimPresence(String name) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.withClaim(name, (Claim claim, DecodedJWT decodedJWT) -> true);
            return this;
        }

        @Override
        public Verification withNullClaim(String name) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.withClaim(name, (Claim claim, DecodedJWT decodedJWT) -> claim.isNull());
            return this;
        }

        @Override
        public Verification withClaim(String name, Boolean value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.equals(claim.asBoolean()));
            return this;
        }

        @Override
        public Verification withClaim(String name, Integer value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.equals(claim.asInt()));
            return this;
        }

        @Override
        public Verification withClaim(String name, Long value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.equals(claim.asLong()));
            return this;
        }

        @Override
        public Verification withClaim(String name, Double value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.equals(claim.asDouble()));
            return this;
        }

        @Override
        public Verification withClaim(String name, String value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.equals(claim.asString()));
            return this;
        }

        @Override
        public Verification withClaim(String name, Date value) throws IllegalArgumentException {
            return this.withClaim(name, value != null ? value.toInstant() : null);
        }

        @Override
        public Verification withClaim(String name, Instant value) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, value) || value.truncatedTo(ChronoUnit.SECONDS).equals(claim.asInstant()));
            return this;
        }

        @Override
        public Verification withClaim(String name, BiPredicate<Claim, DecodedJWT> predicate) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, predicate) || predicate.test((Claim)claim, (DecodedJWT)decodedJWT));
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, String ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, items) || this.assertValidCollectionClaim((Claim)claim, items));
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, Integer ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, items) || this.assertValidCollectionClaim((Claim)claim, items));
            return this;
        }

        @Override
        public Verification withArrayClaim(String name, Long ... items) throws IllegalArgumentException {
            this.assertNonNull(name);
            this.addCheck(name, (claim, decodedJWT) -> this.verifyNull((Claim)claim, items) || this.assertValidCollectionClaim((Claim)claim, items));
            return this;
        }

        @Override
        public JWTVerifier build() {
            return this.build(Clock.systemUTC());
        }

        public JWTVerifier build(Clock clock) {
            this.clock = clock;
            this.addMandatoryClaimChecks();
            return new JWTVerifier(this.algorithm, this.expectedChecks);
        }

        public long getLeewayFor(String name) {
            return this.customLeeways.getOrDefault(name, this.defaultLeeway);
        }

        private void addMandatoryClaimChecks() {
            long expiresAtLeeway = this.getLeewayFor("exp");
            long notBeforeLeeway = this.getLeewayFor("nbf");
            long issuedAtLeeway = this.getLeewayFor("iat");
            this.expectedChecks.add(this.constructExpectedCheck("exp", (claim, decodedJWT) -> this.assertValidInstantClaim("exp", (Claim)claim, expiresAtLeeway, true)));
            this.expectedChecks.add(this.constructExpectedCheck("nbf", (claim, decodedJWT) -> this.assertValidInstantClaim("nbf", (Claim)claim, notBeforeLeeway, false)));
            if (!this.ignoreIssuedAt) {
                this.expectedChecks.add(this.constructExpectedCheck("iat", (claim, decodedJWT) -> this.assertValidInstantClaim("iat", (Claim)claim, issuedAtLeeway, false)));
            }
        }

        private boolean assertValidCollectionClaim(Claim claim, Object[] expectedClaimValue) {
            List<Object> claimArr;
            Object[] claimAsObject = claim.as(Object[].class);
            if (expectedClaimValue instanceof Long[]) {
                claimArr = new ArrayList(claimAsObject.length);
                for (Object cao : claimAsObject) {
                    if (cao instanceof Integer) {
                        claimArr.add(((Integer)cao).longValue());
                        continue;
                    }
                    claimArr.add(cao);
                }
            } else {
                claimArr = Arrays.asList(claim.as(Object[].class));
            }
            List<Object> valueArr = Arrays.asList(expectedClaimValue);
            return claimArr.containsAll(valueArr);
        }

        private boolean assertValidInstantClaim(String claimName, Claim claim, long leeway, boolean shouldBeFuture) {
            Instant claimVal = claim.asInstant();
            Instant now = this.clock.instant().truncatedTo(ChronoUnit.SECONDS);
            if (shouldBeFuture) {
                boolean isValid = this.assertInstantIsFuture(claimVal, leeway, now);
                if (!isValid) {
                    throw new TokenExpiredException(String.format("The Token has expired on %s.", claimVal), claimVal);
                }
            } else {
                boolean isValid = this.assertInstantIsPast(claimVal, leeway, now);
                if (!isValid) {
                    throw new IncorrectClaimException(String.format("The Token can't be used before %s.", claimVal), claimName, claim);
                }
            }
            return true;
        }

        private boolean assertInstantIsFuture(Instant claimVal, long leeway, Instant now) {
            return claimVal == null || !now.minus(Duration.ofSeconds(leeway)).isAfter(claimVal);
        }

        private boolean assertInstantIsPast(Instant claimVal, long leeway, Instant now) {
            return claimVal == null || !now.plus(Duration.ofSeconds(leeway)).isBefore(claimVal);
        }

        private boolean assertValidAudienceClaim(List<String> audience, List<String> values, boolean shouldContainAll) {
            return !(audience == null || shouldContainAll && !audience.containsAll(values) || !shouldContainAll && Collections.disjoint(audience, values));
        }

        private void assertPositive(long leeway) {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
        }

        private void assertNonNull(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The Custom Claim's name can't be null.");
            }
        }

        private void addCheck(String name, BiPredicate<Claim, DecodedJWT> predicate) {
            this.expectedChecks.add(this.constructExpectedCheck(name, (claim, decodedJWT) -> {
                if (claim.isMissing()) {
                    throw new MissingClaimException(name);
                }
                return predicate.test((Claim)claim, (DecodedJWT)decodedJWT);
            }));
        }

        private ExpectedCheckHolder constructExpectedCheck(final String claimName, final BiPredicate<Claim, DecodedJWT> check) {
            return new ExpectedCheckHolder(){

                @Override
                public String getClaimName() {
                    return claimName;
                }

                @Override
                public boolean verify(Claim claim, DecodedJWT decodedJWT) {
                    return check.test(claim, decodedJWT);
                }
            };
        }

        private boolean verifyNull(Claim claim, Object value) {
            return value == null && claim.isNull();
        }

        private boolean isNullOrEmpty(String[] args) {
            if (args == null || args.length == 0) {
                return true;
            }
            boolean isAllNull = true;
            for (String arg : args) {
                if (arg == null) continue;
                isAllNull = false;
                break;
            }
            return isAllNull;
        }
    }
}

