/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.encrypt;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.common.encrypt.Byte2Hex;
import java.security.MessageDigest;
import java.util.logging.Logger;

public class SaltEncoder {
    private static final Logger logger = Logger.getLogger("PasswordEncoder");
    private String salt;
    private String algorithm;

    protected SaltEncoder() {
    }

    public SaltEncoder(String salt, String algorithm) {
        this.salt = salt;
        this.algorithm = algorithm;
    }

    public static String md5SaltEncode(String salt, String rawText) {
        return new SaltEncoder(salt, "MD5").encode(rawText);
    }

    public static boolean md5SaltValid(String salt, String encodeText, String rawText) {
        return new SaltEncoder(salt, "MD5").isValid(encodeText, rawText);
    }

    public String encode(String rawText) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            return Byte2Hex.byte2Hex(md.digest(this.mergeRawTextAndSalt(rawText).getBytes(SSOConfig.getSSOEncoding())));
        }
        catch (Exception e) {
            logger.severe(" SaltEncoder encode exception.");
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid(String encodeText, String rawText) {
        return this.encode(rawText).equals(encodeText);
    }

    private String mergeRawTextAndSalt(String rawText) {
        if (rawText == null) {
            rawText = "";
        }
        if (this.salt == null || "".equals(this.salt)) {
            return rawText;
        }
        StringBuffer mt = new StringBuffer();
        mt.append(rawText);
        mt.append("#");
        mt.append(this.salt);
        return mt.toString();
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

