/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.common.shiro;

import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.shiro.SSOAuthToken;
import com.baomidou.kisso.common.shiro.ShiroPermission;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOAuthRealm
extends AuthorizingRealm {
    private ShiroPermission shiroPermission;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        Token token = (Token)this.getAvailablePrincipal(principals);
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        List<String> permissions = this.shiroPermission.getPermissions(token);
        if (permissions != null) {
            authorizationInfo.addStringPermissions(permissions);
        }
        return authorizationInfo;
    }

    public boolean supports(AuthenticationToken token) {
        return token != null && SSOAuthToken.class.isAssignableFrom(token.getClass());
    }

    public Class<?> getAuthenticationTokenClass() {
        return SSOAuthToken.class;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return new SimpleAuthenticationInfo(token.getPrincipal(), token.getCredentials(), this.getName());
    }

    public ShiroPermission getShiroPermission() {
        return this.shiroPermission;
    }

    public void setShiroPermission(ShiroPermission shiroPermission) {
        this.shiroPermission = shiroPermission;
    }
}

