/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class Base58Helper {
    public static final char[] ALPHABET;
    private static final int[] INDEXES;

    public static String encode(byte[] value) {
        int zeroCount;
        if (value.length == 0) {
            return "";
        }
        byte[] input = Base58Helper.copyOfRange(value, 0, value.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = Base58Helper.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = (byte)ALPHABET[mod];
        }
        while (j < temp.length && temp[j] == ALPHABET[0]) {
            ++j;
        }
        while (--zeroCount >= 0) {
            temp[--j] = (byte)ALPHABET[0];
        }
        byte[] output = Base58Helper.copyOfRange(temp, j, temp.length);
        try {
            return new String(output, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(long id) {
        return Base58Helper.encode(Base58Helper.long2Bytes(id));
    }

    public static long decode(String input) {
        return Base58Helper.bytes2Long(Base58Helper.decodeInner(input));
    }

    public static byte[] decodeInner(String input) {
        int zeroCount;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int digit58 = -1;
            if (c >= '\u0000' && c < '\u0080') {
                digit58 = INDEXES[c];
            }
            if (digit58 < 0) {
                throw new RuntimeException("Illegal character " + c + " at " + i);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int j = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = Base58Helper.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--j] = mod;
        }
        while (j < temp.length && temp[j] == 0) {
            ++j;
        }
        return Base58Helper.copyOfRange(temp, j - zeroCount, temp.length);
    }

    public static byte[] doubleDigest(byte[] input, int offset, int length) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(input, offset, length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * 58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    private static byte[] copyOfRange(byte[] source, int from, int to) {
        byte[] range = new byte[to - from];
        System.arraycopy(source, from, range, 0, range.length);
        return range;
    }

    public static synchronized String compressedUUID() {
        UUID uuid = UUID.randomUUID();
        byte[] byUuid = new byte[16];
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        Base58Helper.long2bytes(most, byUuid, 0);
        Base58Helper.long2bytes(least, byUuid, 8);
        return Base58Helper.encode(byUuid);
    }

    public static byte[] long2Bytes(long num) {
        byte[] byteNum = new byte[8];
        for (int ix = 0; ix < 8; ++ix) {
            int offset = 64 - (ix + 1) * 8;
            byteNum[ix] = (byte)(num >> offset & 0xFFL);
        }
        return byteNum;
    }

    public static long bytes2Long(byte[] byteNum) {
        long num = 0L;
        for (int ix = 0; ix < 8; ++ix) {
            num <<= 8;
            num |= (long)(byteNum[ix] & 0xFF);
        }
        return num;
    }

    public static void long2bytes(long value, byte[] bytes, int offset) {
        int offsetLocal = offset;
        for (int i = 7; i > -1; --i) {
            bytes[offsetLocal++] = (byte)(value >> 8 * i & 0xFFL);
        }
    }

    static {
        int i;
        ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
        INDEXES = new int[128];
        for (i = 0; i < INDEXES.length; ++i) {
            Base58Helper.INDEXES[i] = -1;
        }
        for (i = 0; i < ALPHABET.length; ++i) {
            Base58Helper.INDEXES[Base58Helper.ALPHABET[i]] = i;
        }
    }
}

