/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common;

import com.baomidou.kisso.common.util.EnvUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;

public class GraphicsMagickHelper {
    private static ConvertCmd convert = null;

    protected static ConvertCmd localConvertCmd() {
        if (convert == null) {
            convert = new ConvertCmd(true);
            if (EnvUtil.isLinux()) {
                convert.setSearchPath("/usr/local/bin");
            } else {
                convert.setSearchPath("C:/GraphicsMagick-1.3.23-Q8");
            }
        }
        return convert;
    }

    public static String getImageInfo(String imagePath) {
        String line = null;
        try {
            IMOperation op = new IMOperation();
            op.format("width:%w,height:%h,path:%d%f,size:%b%[EXIF:DateTimeOriginal]");
            op.addImage(1);
            IdentifyCmd identifyCmd = new IdentifyCmd(true);
            ArrayListOutputConsumer output = new ArrayListOutputConsumer();
            identifyCmd.setOutputConsumer((OutputConsumer)output);
            identifyCmd.run((Operation)op, new Object[]{imagePath});
            ArrayList cmdOutput = output.getOutput();
            assert (cmdOutput.size() == 1);
            line = (String)cmdOutput.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return line;
    }

    public boolean rotate(String imagePath, String newPath, double degree) {
        boolean flag = false;
        try {
            degree %= 360.0;
            if (degree <= 0.0) {
                degree = 360.0 + degree;
            }
            IMOperation op = new IMOperation();
            op.addImage(new String[]{imagePath});
            op.rotate(Double.valueOf(degree));
            op.addImage(new String[]{newPath});
            GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[0]);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            System.out.println("\u56fe\u7247\u65cb\u8f6c\u5931\u8d25!");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cropImage(String imagePath, String newPath, int x, int y, int width, int height) {
        boolean flag = false;
        try {
            IMOperation op = new IMOperation();
            op.addImage(new String[]{imagePath});
            op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(x), Integer.valueOf(y));
            op.addImage(new String[]{newPath});
            GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[0]);
            flag = true;
        }
        catch (IOException e) {
            System.out.println("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef!");
            flag = false;
        }
        catch (InterruptedException e) {
            flag = false;
        }
        catch (IM4JavaException e) {
            flag = false;
        }
        return flag;
    }

    public static String cropImageQuality(int width, int height, String srcPath, String newPath, int type, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage();
        String raw = "";
        raw = type == 1 ? width + "x" + height + "^" : width + "%x" + height + "%";
        op.addRawArgs(new String[]{"-sample", raw});
        if (quality != null && quality.equals("")) {
            op.addRawArgs(new String[]{"-quality", quality});
        }
        op.addImage();
        GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[]{srcPath, newPath});
        return newPath;
    }

    public static void zoom(String srcPath, String destinationPath, int needWidth, int needHeight, int quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(Integer.valueOf(needWidth), Integer.valueOf(needHeight));
        if (quality > 0) {
            op.addRawArgs(new String[]{"-quality", String.valueOf(quality)});
        }
        op.addImage(new String[]{destinationPath});
        GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[0]);
    }

    public static void zoom(String srcPath, String destinationPath, int quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.addRawArgs(new String[]{"-thumbnail", "40%x40%"});
        if (quality > 0) {
            op.addRawArgs(new String[]{"-quality", String.valueOf(quality)});
        }
        op.addImage(new String[]{destinationPath});
        GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[0]);
    }

    public IMOperation getOpWaterMark(String filePath) {
        IMOperation op = new IMOperation();
        op.gravity("SouthEast");
        op.dissolve(Integer.valueOf(80));
        op.geometry(null, null, Integer.valueOf(10), Integer.valueOf(5));
        op.addImage(new String[]{"/opt/water.jpg"});
        op.addImage(new String[]{filePath});
        op.addImage(new String[]{filePath});
        return op;
    }

    public static void cropImageCenter(String srcPath, String desPath, int rectw, int recth) throws IOException, InterruptedException, IM4JavaException {
        IMOperation op = new IMOperation();
        op.addImage();
        op.resize(Integer.valueOf(rectw), Integer.valueOf(recth), Character.valueOf('^')).gravity("center").extent(Integer.valueOf(rectw), Integer.valueOf(recth));
        op.addImage();
        GraphicsMagickHelper.localConvertCmd().run((Operation)op, new Object[]{srcPath, desPath});
    }
}

