/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.common.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.Assert;

public final class BeanUtil
extends BeanUtils {
    protected BeanUtil() {
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class<?> clazz = Class.forName(clazzStr);
            return BeanUtil.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T clone(Object src, Class<T> clazz) {
        BeanCopier copier = BeanCopier.create(src.getClass(), clazz, (boolean)false);
        T to = BeanUtil.newInstance(clazz);
        copier.copy(src, to, null);
        return to;
    }

    public static void copy(Object source, Object target) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtil.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtil.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target", ex);
            }
        }
    }

    public static <K, V> Map<K, V> toMap(Object src) {
        return BeanMap.create((Object)src);
    }
}

