/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.framework.controller.AjaxResult;
import com.baomidou.framework.exception.WebException;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.SSOToken;
import com.baomidou.kisso.common.util.HttpUtil;
import com.baomidou.mybatisplus.plugins.Page;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SuperController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected HttpSession session;
    @Autowired
    protected ServletContext application;

    protected Long getCurrentUserId() {
        return this.getSSOToken().getId();
    }

    protected SSOToken getSSOToken() {
        SSOToken tk = (SSOToken)SSOHelper.attrToken((HttpServletRequest)this.request);
        if (tk == null) {
            throw new WebException("-1", "The user does not exist, please relogin.");
        }
        return tk;
    }

    protected boolean isPost() {
        return HttpUtil.isPost((HttpServletRequest)this.request);
    }

    protected boolean isGet() {
        return HttpUtil.isGet((HttpServletRequest)this.request);
    }

    protected <T> Page<T> getPage() {
        return this.getPage(10);
    }

    protected <T> Page<T> getPage(int size) {
        int _size = size;
        int _index = 1;
        if (this.request.getParameter("_size") != null) {
            _size = Integer.parseInt(this.request.getParameter("_size"));
        }
        if (this.request.getParameter("_index") != null) {
            _index = Integer.parseInt(this.request.getParameter("_index"));
        }
        return new Page(_index, _size);
    }

    protected String redirectTo(String url) {
        StringBuffer rto = new StringBuffer("redirect:");
        rto.append(url);
        return rto.toString();
    }

    protected String toJson(Object object) {
        return JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
    }

    protected String toJson(Object object, String format) {
        if (format == null) {
            return this.toJson(object);
        }
        return JSON.toJSONStringWithDateFormat((Object)object, (String)format, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    protected String callback(AjaxResult object) {
        return this.callback(object, null);
    }

    protected String callback(AjaxResult object, String format) {
        String callback = this.request.getParameter("callback");
        if (callback == null) {
            return this.toJson(object, format);
        }
        StringBuffer json = new StringBuffer();
        json.append(callback);
        json.append("(").append(this.toJson(object, format)).append(")");
        return json.toString();
    }

    protected String callbackSuccess(Object obj) {
        return this.callback(new AjaxResult(obj));
    }

    protected String callbackFail(String message) {
        return this.callback(new AjaxResult(false, message));
    }
}

