/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.datasource;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSource.class);
    private static final AtomicLong dbCount = new AtomicLong(0L);
    private static final ThreadLocal<String> dataSourceHolder = new ThreadLocal();

    public static void use(String key, int dbSize) {
        if (dbSize < 1) {
            dataSourceHolder.set(key);
        } else {
            long c = dbCount.incrementAndGet();
            dataSourceHolder.set(key + (c %= (long)dbSize));
        }
    }

    public static void reset() {
        dataSourceHolder.remove();
    }

    protected Object determineCurrentLookupKey() {
        String key = dataSourceHolder.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("currenty datasource :" + key);
        }
        return key;
    }
}

