/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import com.baomidou.framework.common.SwConstants;
import com.baomidou.framework.exception.SpringWindException;
import com.baomidou.framework.velocity.RunEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class LogbackConfigListener
implements ServletContextListener {
    private String charset = SwConstants.UTF_8;
    private RunEnvironment runEnvironment;
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    private static LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static JoranConfigurator configurator = new JoranConfigurator();

    public void contextDestroyed(ServletContextEvent event) {
        lc.stop();
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            String location = event.getServletContext().getInitParameter(CONFIG_LOCATION_PARAM);
            Resource resource = new DefaultResourceLoader().getResource(location);
            HashMap<String, RunEnvironment> context = new HashMap<String, RunEnvironment>();
            context.put("env", this.getRunEnvironment());
            StringWriter writer = new StringWriter();
            BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream(), this.getCharset()));
            Velocity.evaluate((org.apache.velocity.context.Context)new VelocityContext(context), (Writer)writer, (String)"LogbackConfigListener", (Reader)br);
            this.initLogging(new ByteArrayInputStream(writer.toString().getBytes(this.getCharset())));
        }
        catch (Exception e) {
            throw new SpringWindException(e);
        }
    }

    public void initLogging(InputStream in) {
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(in);
        }
        catch (Exception e) {
            throw new SpringWindException(e);
        }
        lc.start();
    }

    public RunEnvironment getRunEnvironment() {
        if (this.runEnvironment == null) {
            return new RunEnvironment();
        }
        return this.runEnvironment;
    }

    public void setRunEnvironment(RunEnvironment runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

