/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.spring;

import com.baomidou.framework.exception.SpringWindException;
import com.baomidou.kisso.common.util.EnvUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class MutilPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String ONLINE = "online";
    private static final String DEV = "dev";
    private static final String TEST = "test";
    private String configEnv = "spring_runmode";
    private Properties properties;

    public String getRunMode() {
        String mode = System.getenv(this.getConfigEnv());
        if (mode == null || "".equals(mode)) {
            mode = System.getProperty(this.getConfigEnv());
        }
        if (mode != null) {
            if (ONLINE.equals(mode)) {
                mode = ONLINE;
            } else if (DEV.equals(mode)) {
                mode = DEV;
            } else if (TEST.equals(mode)) {
                mode = TEST;
            }
        } else {
            mode = EnvUtil.isLinux() ? ONLINE : DEV;
        }
        System.err.println("-Dspring_runmode=" + mode + "_mode");
        return mode;
    }

    protected Properties mergeProperties() throws IOException {
        this.properties = this.convertMergeProperties(super.mergeProperties());
        return this.properties;
    }

    protected Properties convertMergeProperties(Properties mergeProperties) {
        Properties prop = new Properties();
        String runMode = "_" + this.getRunMode() + "_mode";
        Set<Map.Entry<Object, Object>> es = mergeProperties.entrySet();
        for (Map.Entry<Object, Object> entry : es) {
            String key;
            String realKey = key = (String)entry.getKey();
            int idx = key.lastIndexOf("_mode");
            if (idx > 0) {
                realKey = key.contains(runMode) ? key.substring(0, key.lastIndexOf(runMode)) : null;
            }
            if (realKey == null || prop.containsKey(realKey)) continue;
            Object value = null;
            value = idx > 0 ? mergeProperties.get(realKey + runMode) : mergeProperties.get(realKey);
            if (value != null) {
                prop.put(realKey, value);
                continue;
            }
            throw new SpringWindException("impossible empty property for " + realKey);
        }
        return prop;
    }

    public String getProperty(String key) {
        return this.resolvePlaceholder(key, this.properties);
    }

    public String getConfigEnv() {
        return this.configEnv;
    }

    public void setConfigEnv(String configEnv) {
        if (configEnv != null && !"".equals(configEnv)) {
            this.configEnv = configEnv;
        }
    }
}

