/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.velocity;

import com.baomidou.framework.common.SwConstants;
import com.baomidou.framework.exception.SpringWindException;
import com.baomidou.framework.velocity.RunEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringValueResolver;

public class VelocityPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private String charset = SwConstants.UTF_8;
    private static VelocityContext velocityContext = null;
    private Resource[] locations;
    private RunEnvironment runEnvironment;
    private String placeholderValue = "";

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource ... locations) {
        this.locations = locations;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        PlaceholderResolvingStringValueResolver valueResolver = new PlaceholderResolvingStringValueResolver(props);
        this.doProcessProperties(beanFactoryToProcess, valueResolver);
    }

    public void fillMergeProperties(Properties prop, InputStream input) {
        try {
            StringWriter writer = new StringWriter();
            BufferedReader br = new BufferedReader(new InputStreamReader(input, this.getCharset()));
            if (velocityContext == null) {
                HashMap<Object, Object> context = new HashMap<Object, Object>();
                context.put("env", this.getRunEnvironment());
                context.putAll(System.getProperties());
                velocityContext = new VelocityContext(context);
            }
            Velocity.evaluate((Context)velocityContext, (Writer)writer, (String)"VelocityPropertyPlaceholderConfigurer", (Reader)br);
            prop.load(new StringReader(writer.toString()));
        }
        catch (Exception e) {
            throw new SpringWindException(e);
        }
    }

    protected void loadProperties(Properties props) throws IOException {
        if (this.locations != null && props != null) {
            for (Resource location : this.locations) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading properties file from " + location));
                }
                this.fillMergeProperties(props, location.getInputStream());
            }
        }
    }

    public RunEnvironment getRunEnvironment() {
        if (this.runEnvironment == null) {
            return new RunEnvironment();
        }
        return this.runEnvironment;
    }

    public void setRunEnvironment(RunEnvironment runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPlaceholderValue() {
        return this.placeholderValue;
    }

    public void setPlaceholderValue(String placeholderValue) {
        this.placeholderValue = placeholderValue;
    }

    private class PropertyPlaceholderConfigurerResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final Properties props;

        private PropertyPlaceholderConfigurerResolver(Properties props) {
            this.props = props;
        }

        public String resolvePlaceholder(String placeholderName) {
            return VelocityPropertyPlaceholderConfigurer.this.resolvePlaceholder(placeholderName, this.props, 1);
        }
    }

    private class PlaceholderResolvingStringValueResolver
    implements StringValueResolver {
        private final PropertyPlaceholderHelper helper;
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver;

        public PlaceholderResolvingStringValueResolver(Properties props) {
            this.helper = new PropertyPlaceholderHelper(VelocityPropertyPlaceholderConfigurer.this.placeholderPrefix, VelocityPropertyPlaceholderConfigurer.this.placeholderSuffix, VelocityPropertyPlaceholderConfigurer.this.valueSeparator, VelocityPropertyPlaceholderConfigurer.this.ignoreUnresolvablePlaceholders);
            this.resolver = new PropertyPlaceholderConfigurerResolver(props);
        }

        public String resolveStringValue(String strVal) throws BeansException {
            String value = this.helper.replacePlaceholders(strVal, this.resolver);
            if (value.contains(VelocityPropertyPlaceholderConfigurer.this.placeholderPrefix) && value.equals(strVal)) {
                return VelocityPropertyPlaceholderConfigurer.this.placeholderValue;
            }
            return value.equals(VelocityPropertyPlaceholderConfigurer.this.nullValue) ? null : value;
        }
    }
}

