/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps;

import com.ejlchina.data.Array;
import com.ejlchina.data.DataConvertor;
import com.ejlchina.data.Mapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

public interface MsgConvertor
extends DataConvertor {
    public String mediaType();

    public static class FormConvertor
    implements MsgConvertor {
        private final DataConvertor convertor;

        public FormConvertor(DataConvertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public String mediaType() {
            return "application/x-www-form-urlencoded";
        }

        public Mapper toMapper(InputStream in, Charset charset) {
            return this.convertor.toMapper(in, charset);
        }

        public Array toArray(InputStream in, Charset charset) {
            return this.convertor.toArray(in, charset);
        }

        public byte[] serialize(Object object, Charset charset) {
            byte[] data = this.convertor.serialize(object, charset);
            Mapper mapper = this.convertor.toMapper((InputStream)new ByteArrayInputStream(data), charset);
            StringBuilder sb = new StringBuilder();
            for (String key : mapper.keySet()) {
                sb.append(key).append('=').append(mapper.getString(key)).append('&');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString().getBytes(charset);
        }

        public <T> T toBean(Type type, InputStream in, Charset charset) {
            return (T)this.convertor.toBean(type, in, charset);
        }

        public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toList(type, in, charset);
        }
    }
}

