/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.okhttps.internal;

import com.ejlchina.okhttps.OnCallback;
import com.ejlchina.okhttps.Process;
import com.ejlchina.okhttps.internal.RealProcess;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class ProcessInputStream
extends InputStream {
    private final InputStream input;
    private final OnCallback<Process> onProcess;
    private final Executor callbackExecutor;
    private final long stepBytes;
    private final RealProcess process;
    private boolean doneCalled = false;
    private long step = 0L;

    public ProcessInputStream(InputStream input, OnCallback<Process> onProcess, long totalBytes, long stepBytes, long doneBytes, Executor callbackExecutor) {
        this.input = input;
        this.onProcess = onProcess;
        this.stepBytes = stepBytes;
        this.callbackExecutor = callbackExecutor;
        this.process = new RealProcess(totalBytes, doneBytes);
        this.step = doneBytes / stepBytes;
    }

    @Override
    public int read() throws IOException {
        int data = this.input.read();
        if (data > -1) {
            this.process.increaseDoneBytes();
        }
        if (this.process.notDoneOrReached(this.step * this.stepBytes)) {
            return data;
        }
        if (this.process.isDone()) {
            if (this.doneCalled) {
                return data;
            }
            this.doneCalled = true;
        }
        ++this.step;
        this.callbackExecutor.execute(() -> this.onProcess.on(this.process));
        return data;
    }
}

