/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopOrderService;
import cn.binarywang.wx.miniapp.bean.shop.WxMaShopOrderInfo;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopOrderPayRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAddOrderResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetOrderResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopOrderServiceImpl
implements WxMaShopOrderService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopOrderServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private static final String MATCH_KEY = "is_matched";
    private final WxMaService wxMaService;

    @Override
    public Boolean checkScene(Integer scene) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/scene/check", GsonHelper.buildJsonObject((Object[])new Object[]{"scene", scene}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return jsonObject.get(MATCH_KEY).getAsBoolean();
    }

    @Override
    public WxMaShopAddOrderResponse addOrder(WxMaShopOrderInfo orderInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/order/add", orderInfo);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAddOrderResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAddOrderResponse.class);
    }

    @Override
    public WxMaShopBaseResponse orderPay(WxMaShopOrderPayRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/order/pay", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopGetOrderResponse getOrder(Integer orderId, String outOrderId, String openid) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/order/get", GsonHelper.buildJsonObject((Object[])new Object[]{"order_id", orderId, "out_order_id", outOrderId, "openid", openid}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopGetOrderResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopGetOrderResponse.class);
    }

    public WxMaShopOrderServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

