/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.open.bean.auth.WxOpenAuthorizerInfo;
import me.chanjar.weixin.open.util.json.WxOpenGsonBuilder;

public class WxOpenAuthorizerInfoGsonAdapter
implements JsonDeserializer<WxOpenAuthorizerInfo> {
    public WxOpenAuthorizerInfo deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        WxOpenAuthorizerInfo authorizationInfo = new WxOpenAuthorizerInfo();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        authorizationInfo.setNickName(GsonHelper.getString((JsonObject)jsonObject, (String)"nick_name"));
        authorizationInfo.setHeadImg(GsonHelper.getString((JsonObject)jsonObject, (String)"head_img"));
        authorizationInfo.setUserName(GsonHelper.getString((JsonObject)jsonObject, (String)"user_name"));
        authorizationInfo.setPrincipalName(GsonHelper.getString((JsonObject)jsonObject, (String)"principal_name"));
        authorizationInfo.setAlias(GsonHelper.getString((JsonObject)jsonObject, (String)"alias"));
        authorizationInfo.setQrcodeUrl(GsonHelper.getString((JsonObject)jsonObject, (String)"qrcode_url"));
        authorizationInfo.setSignature(GsonHelper.getString((JsonObject)jsonObject, (String)"signature"));
        if (jsonObject.has("service_type_info")) {
            authorizationInfo.setServiceTypeInfo(GsonHelper.getInteger((JsonObject)jsonObject.getAsJsonObject("service_type_info"), (String)"id"));
        }
        if (jsonObject.has("verify_type_info")) {
            authorizationInfo.setVerifyTypeInfo(GsonHelper.getInteger((JsonObject)jsonObject.getAsJsonObject("verify_type_info"), (String)"id"));
        }
        Map businessInfo = (Map)WxOpenGsonBuilder.create().fromJson(jsonObject.get("business_info"), new TypeToken<Map<String, Integer>>(){}.getType());
        authorizationInfo.setBusinessInfo(businessInfo);
        if (jsonObject.has("MiniProgramInfo")) {
            WxOpenAuthorizerInfo.MiniProgramInfo miniProgramInfo = (WxOpenAuthorizerInfo.MiniProgramInfo)WxOpenGsonBuilder.create().fromJson(jsonObject.get("MiniProgramInfo"), new TypeToken<WxOpenAuthorizerInfo.MiniProgramInfo>(){}.getType());
            authorizationInfo.setMiniProgramInfo(miniProgramInfo);
        }
        return authorizationInfo;
    }
}

