/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class ProxyResultSetBase
implements ResultSet {
    protected ResultSet delegate;
    protected PooledConnection pConn;
    boolean isClosed;
    private ProxyStatementBase owner;

    public ProxyResultSetBase(ResultSet delegate, PooledConnection pConn) {
        this.delegate = delegate;
        this.pConn = pConn;
    }

    public ProxyResultSetBase(ResultSet delegate, ProxyStatementBase owner, PooledConnection pConn) {
        this.delegate = delegate;
        this.owner = owner;
        this.pConn = pConn;
        owner.setOpenResultSet(this);
    }

    boolean isDelegate(ResultSet delegate) {
        return this.delegate == delegate;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return this.owner;
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    private final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ResultSetClosedException;
        }
    }

    @Override
    public final void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.delegate.close();
        }
        finally {
            this.delegate = PoolStaticCenter.CLOSED_RSLT;
        }
    }

    final void setAsClosed() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

