/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.xa;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.xa.XaResourceWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XaConnectionWrapper
implements XAConnection {
    private boolean isClosed;
    private Connection proxyConn;
    private XAConnection delegate;
    private XaResourceWrapper xaResource;

    public XaConnectionWrapper(XAConnection delegate, Connection proxyConn) {
        this.proxyConn = proxyConn;
        this.delegate = delegate;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolStaticCenter.ConnectionClosedException;
        }
    }

    void checkClosedForXa() throws XAException {
        if (this.isClosed) {
            throw PoolStaticCenter.XaConnectionClosedException;
        }
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        this.proxyConn.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.proxyConn;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        this.checkClosed();
        if (this.xaResource == null) {
            this.xaResource = new XaResourceWrapper(this.delegate.getXAResource(), this);
        }
        return this.xaResource;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }
}

