/*
 * Decompiled with CFR 0.152.
 */
package com.redfin.sitemapgenerator;

import com.redfin.sitemapgenerator.AbstractSitemapGeneratorOptions;
import com.redfin.sitemapgenerator.AbstractSitemapUrlRenderer;
import com.redfin.sitemapgenerator.GoogleLinkSitemapUrl;
import com.redfin.sitemapgenerator.ISitemapUrlRenderer;
import com.redfin.sitemapgenerator.SitemapGenerator;
import com.redfin.sitemapgenerator.SitemapGeneratorBuilder;
import com.redfin.sitemapgenerator.SitemapGeneratorOptions;
import com.redfin.sitemapgenerator.UrlUtils;
import com.redfin.sitemapgenerator.W3CDateFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleLinkSitemapGenerator
extends SitemapGenerator<GoogleLinkSitemapUrl, GoogleLinkSitemapGenerator> {
    public static SitemapGeneratorBuilder<GoogleLinkSitemapGenerator> builder(String baseUrl, File baseDir) throws MalformedURLException {
        return new SitemapGeneratorBuilder<GoogleLinkSitemapGenerator>(baseUrl, baseDir, GoogleLinkSitemapGenerator.class);
    }

    public static SitemapGeneratorBuilder<GoogleLinkSitemapGenerator> builder(URL baseUrl, File baseDir) {
        return new SitemapGeneratorBuilder<GoogleLinkSitemapGenerator>(baseUrl, baseDir, GoogleLinkSitemapGenerator.class);
    }

    public GoogleLinkSitemapGenerator(String baseUrl) throws MalformedURLException {
        this(new SitemapGeneratorOptions(new URL(baseUrl)));
    }

    public GoogleLinkSitemapGenerator(String baseUrl, File baseDir) throws MalformedURLException {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    public GoogleLinkSitemapGenerator(URL baseUrl) {
        this(new SitemapGeneratorOptions(baseUrl));
    }

    public GoogleLinkSitemapGenerator(URL baseUrl, File baseDir) {
        this(new SitemapGeneratorOptions(baseUrl, baseDir));
    }

    GoogleLinkSitemapGenerator(AbstractSitemapGeneratorOptions<?> options) {
        super(options, new Renderer());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Renderer
    extends AbstractSitemapUrlRenderer<GoogleLinkSitemapUrl>
    implements ISitemapUrlRenderer<GoogleLinkSitemapUrl> {
        private Renderer() {
        }

        @Override
        public Class<GoogleLinkSitemapUrl> getUrlClass() {
            return GoogleLinkSitemapUrl.class;
        }

        @Override
        public String getXmlNamespaces() {
            return "xmlns:xhtml=\"http://www.w3.org/1999/xhtml\"";
        }

        @Override
        public void render(GoogleLinkSitemapUrl url, StringBuilder sb, W3CDateFormat dateFormat) {
            StringBuilder tagSb = new StringBuilder();
            for (Map.Entry<URI, Map<String, String>> entry : url.getAlternates().entrySet()) {
                tagSb.append("    <xhtml:link\n");
                tagSb.append("      rel=\"alternate\"\n");
                for (Map.Entry<String, String> innerEntry : entry.getValue().entrySet()) {
                    tagSb.append("      " + innerEntry.getKey() + "=\"" + innerEntry.getValue() + "\"\n");
                }
                tagSb.append("      href=\"" + UrlUtils.escapeXml(entry.getKey().toString()) + "\"\n");
                tagSb.append("    />\n");
            }
            super.render(url, sb, dateFormat, tagSb.toString());
        }
    }
}

