/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.connect;

import com.github.housepower.jdbc.connect.NativeClient;
import com.github.housepower.jdbc.protocol.QueryRequest;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import java.time.ZoneId;

public class NativeContext {
    private final QueryRequest.ClientContext clientCtx;
    private final ServerContext serverCtx;
    private final NativeClient nativeClient;

    public NativeContext(QueryRequest.ClientContext clientCtx, ServerContext serverCtx, NativeClient nativeClient) {
        this.clientCtx = clientCtx;
        this.serverCtx = serverCtx;
        this.nativeClient = nativeClient;
    }

    public QueryRequest.ClientContext clientCtx() {
        return this.clientCtx;
    }

    public ServerContext serverCtx() {
        return this.serverCtx;
    }

    public NativeClient nativeClient() {
        return this.nativeClient;
    }

    public static class ServerContext {
        private final long majorVersion;
        private final long minorVersion;
        private final long reversion;
        private final ZoneId timeZone;
        private final String displayName;
        private final ClickHouseConfig configure;

        public ServerContext(long majorVersion, long minorVersion, long reversion, ClickHouseConfig configure, ZoneId timeZone, String displayName) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.reversion = reversion;
            this.configure = configure;
            this.timeZone = timeZone;
            this.displayName = displayName;
        }

        public long majorVersion() {
            return this.majorVersion;
        }

        public long minorVersion() {
            return this.minorVersion;
        }

        public long reversion() {
            return this.reversion;
        }

        public String version() {
            return this.majorVersion + "." + this.minorVersion + "." + this.reversion;
        }

        public ZoneId timeZone() {
            return this.timeZone;
        }

        public String displayName() {
            return this.displayName;
        }

        public ClickHouseConfig getConfigure() {
            return this.configure;
        }
    }
}

