/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.jdbc.data;

import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.data.IDataType;
import com.github.housepower.jdbc.data.type.DataTypeDate;
import com.github.housepower.jdbc.data.type.DataTypeFloat32;
import com.github.housepower.jdbc.data.type.DataTypeFloat64;
import com.github.housepower.jdbc.data.type.DataTypeIPv4;
import com.github.housepower.jdbc.data.type.DataTypeInt16;
import com.github.housepower.jdbc.data.type.DataTypeInt32;
import com.github.housepower.jdbc.data.type.DataTypeInt64;
import com.github.housepower.jdbc.data.type.DataTypeInt8;
import com.github.housepower.jdbc.data.type.DataTypeUUID;
import com.github.housepower.jdbc.data.type.complex.DataTypeArray;
import com.github.housepower.jdbc.data.type.complex.DataTypeCreator;
import com.github.housepower.jdbc.data.type.complex.DataTypeDateTime;
import com.github.housepower.jdbc.data.type.complex.DataTypeDateTime64;
import com.github.housepower.jdbc.data.type.complex.DataTypeDecimal;
import com.github.housepower.jdbc.data.type.complex.DataTypeEnum16;
import com.github.housepower.jdbc.data.type.complex.DataTypeEnum8;
import com.github.housepower.jdbc.data.type.complex.DataTypeFixedString;
import com.github.housepower.jdbc.data.type.complex.DataTypeNothing;
import com.github.housepower.jdbc.data.type.complex.DataTypeNullable;
import com.github.housepower.jdbc.data.type.complex.DataTypeString;
import com.github.housepower.jdbc.data.type.complex.DataTypeTuple;
import com.github.housepower.jdbc.misc.LRUCache;
import com.github.housepower.jdbc.misc.SQLLexer;
import com.github.housepower.jdbc.misc.Validate;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DataTypeFactory {
    private static final LRUCache<String, IDataType> DATA_TYPE_CACHE = new LRUCache(1024);
    private static final Map<String, IDataType> dataTypes = DataTypeFactory.initialDataTypes();

    public static IDataType get(String type, NativeContext.ServerContext serverContext) throws SQLException {
        IDataType dataType = DATA_TYPE_CACHE.get(type);
        if (dataType != null) {
            DATA_TYPE_CACHE.put(type, dataType);
            return dataType;
        }
        SQLLexer lexer = new SQLLexer(0, type);
        dataType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.eof());
        DATA_TYPE_CACHE.put(type, dataType);
        return dataType;
    }

    public static IDataType get(SQLLexer lexer, NativeContext.ServerContext serverContext) throws SQLException {
        String dataTypeName = String.valueOf(lexer.bareWord());
        if (dataTypeName.equalsIgnoreCase("Tuple")) {
            return DataTypeTuple.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Array")) {
            return DataTypeArray.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Enum8")) {
            return DataTypeEnum8.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Enum16")) {
            return DataTypeEnum16.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("DateTime")) {
            return DataTypeDateTime.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("DateTime64")) {
            return DataTypeDateTime64.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Nullable")) {
            return DataTypeNullable.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("FixedString") || dataTypeName.equals("Binary")) {
            return DataTypeFixedString.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Decimal")) {
            return DataTypeDecimal.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("String")) {
            return DataTypeString.CREATOR.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Nothing")) {
            return DataTypeNothing.CREATOR.createDataType(lexer, serverContext);
        }
        IDataType dataType = dataTypes.get(dataTypeName.toLowerCase(Locale.ROOT));
        Validate.isTrue(dataType != null, "Unknown data type: " + dataTypeName);
        return dataType;
    }

    private static Map<String, IDataType> initialDataTypes() {
        HashMap<String, IDataType> creators = new HashMap<String, IDataType>();
        DataTypeFactory.registerType(creators, new DataTypeIPv4());
        DataTypeFactory.registerType(creators, new DataTypeUUID());
        DataTypeFactory.registerType(creators, new DataTypeFloat32());
        DataTypeFactory.registerType(creators, new DataTypeFloat64());
        DataTypeFactory.registerType(creators, new DataTypeInt8("Int8"));
        DataTypeFactory.registerType(creators, new DataTypeInt16("Int16"));
        DataTypeFactory.registerType(creators, new DataTypeInt32("Int32"));
        DataTypeFactory.registerType(creators, new DataTypeInt64("Int64"));
        DataTypeFactory.registerType(creators, new DataTypeInt8("UInt8"));
        DataTypeFactory.registerType(creators, new DataTypeInt16("UInt16"));
        DataTypeFactory.registerType(creators, new DataTypeInt32("UInt32"));
        DataTypeFactory.registerType(creators, new DataTypeInt64("UInt64"));
        DataTypeFactory.registerType(creators, new DataTypeDate());
        return creators;
    }

    private static void registerType(Map<String, IDataType> creators, IDataType type) {
        creators.put(type.name().toLowerCase(Locale.ROOT), type);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), type);
        }
    }

    private static Map<String, DataTypeCreator> initComplexDataTypes() {
        HashMap<String, DataTypeCreator> creators = new HashMap<String, DataTypeCreator>();
        return creators;
    }

    private static void registerComplexType(Map<String, DataTypeCreator> creators, IDataType type, DataTypeCreator creator) {
        creators.put(type.name().toLowerCase(Locale.ROOT), creator);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), creator);
        }
    }
}

