/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.log;

import com.github.housepower.log.FormattingTuple;
import com.github.housepower.log.Logger;
import com.github.housepower.log.MessageFormatter;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class JdkLogger
implements Logger {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final java.util.logging.Logger logger;

    public JdkLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.doLog(Level.FINEST, ft);
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, EMPTY_ARRAY, t);
            this.doLog(Level.FINEST, ft);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.doLog(Level.FINE, ft);
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, EMPTY_ARRAY, t);
            this.doLog(Level.FINE, ft);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.doLog(Level.INFO, ft);
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, EMPTY_ARRAY, t);
            this.doLog(Level.INFO, ft);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.doLog(Level.WARNING, ft);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, EMPTY_ARRAY, t);
            this.doLog(Level.WARNING, ft);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            this.doLog(Level.SEVERE, ft);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(msg, EMPTY_ARRAY, t);
            this.doLog(Level.SEVERE, ft);
        }
    }

    private void doLog(Level level, FormattingTuple ft) {
        this.logger.logrb(level, null, null, (ResourceBundle)null, ft.getMessage(), ft.getThrowable());
    }
}

