/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.paypal.accesstoken;

import cn.hutool.core.util.StrUtil;
import com.ijpay.core.IJPayHttpResponse;
import com.ijpay.core.utils.RetryUtils;
import com.ijpay.paypal.PayPalApi;
import com.ijpay.paypal.PayPalApiConfig;
import com.ijpay.paypal.PayPalApiConfigKit;
import com.ijpay.paypal.accesstoken.AccessToken;
import com.ijpay.paypal.cache.DefaultAccessTokenCache;
import com.ijpay.paypal.cache.IAccessTokenCache;
import java.util.concurrent.Callable;

public class AccessTokenKit {
    private static IAccessTokenCache cache = new DefaultAccessTokenCache();

    public static IAccessTokenCache getCache() {
        return cache;
    }

    public static void setCache(IAccessTokenCache cache) {
        AccessTokenKit.cache = cache;
    }

    public static AccessToken get() {
        return AccessTokenKit.get(PayPalApiConfigKit.getApiConfig().getClientId(), false);
    }

    public static AccessToken get(boolean forceRefresh) {
        return AccessTokenKit.get(PayPalApiConfigKit.getApiConfig().getClientId(), forceRefresh);
    }

    public static AccessToken get(String clientId) {
        return AccessTokenKit.get(clientId, false);
    }

    public static AccessToken get(String clientId, boolean forceRefresh) {
        AccessToken accessToken;
        String json;
        IAccessTokenCache accessTokenCache = AccessTokenKit.getCache();
        if (!forceRefresh && StrUtil.isNotEmpty((CharSequence)(json = accessTokenCache.get(clientId))) && (accessToken = new AccessToken(json, 200)).isAvailable()) {
            return accessToken;
        }
        final PayPalApiConfig apiConfig = PayPalApiConfigKit.getApiConfig(clientId);
        AccessToken result = RetryUtils.retryOnException(3, new Callable<AccessToken>(){

            @Override
            public AccessToken call() {
                IJPayHttpResponse response = PayPalApi.getToken(apiConfig);
                return new AccessToken(response.getBody(), response.getStatus());
            }
        });
        if (null != result) {
            accessTokenCache.set(clientId, result.getCacheJson());
        }
        return result;
    }
}

