/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import org.apache.commons.lang3.StringUtils;

public class EqualToPattern
extends StringValuePattern {
    public EqualToPattern(@JsonProperty(value="equalTo") String testValue) {
        super(testValue);
    }

    public String getEqualTo() {
        return this.expectedValue;
    }

    @Override
    public MatchResult match(String value) {
        return value.equals(this.expectedValue) ? MatchResult.exactMatch() : MatchResult.partialMatch(this.normalisedLevenshteinDistance(this.expectedValue, value));
    }

    private double normalisedLevenshteinDistance(String one, String two) {
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = StringUtils.getLevenshteinDistance((CharSequence)one, (CharSequence)two);
        return actualDistance / maxDistance;
    }
}

