/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MatchesXPathPattern
extends StringValuePattern {
    private final Map<String, String> xpathNamespaces;

    public MatchesXPathPattern(@JsonProperty(value="matchesXPath") String expectedValue, @JsonProperty(value="namespaces") Map<String, String> namespaces) {
        super(expectedValue);
        this.xpathNamespaces = namespaces == null || namespaces.isEmpty() ? null : namespaces;
    }

    public MatchesXPathPattern withXPathNamespace(String name, String namespaceUri) {
        ImmutableMap namespaceMap = ImmutableMap.builder().putAll((Map)MoreObjects.firstNonNull(this.xpathNamespaces, Collections.emptyMap())).put((Object)name, (Object)namespaceUri).build();
        return new MatchesXPathPattern(this.expectedValue, (Map<String, String>)namespaceMap);
    }

    public String getMatchesXPath() {
        return this.expectedValue;
    }

    @JsonGetter(value="xPathNamespaces")
    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    @Override
    public MatchResult match(String value) {
        return MatchResult.of(this.isXPathMatch(value));
    }

    private boolean isXPathMatch(String value) {
        try {
            NodeList nodeList;
            Document inDocument = XMLUnit.buildControlDocument((String)value);
            XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
            if (this.xpathNamespaces != null) {
                SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext(this.xpathNamespaces);
                simpleXpathEngine.setNamespaceContext((NamespaceContext)namespaceContext);
            }
            return (nodeList = simpleXpathEngine.getMatchingNodes(this.expectedValue, inDocument)).getLength() > 0;
        }
        catch (SAXException e) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value));
            return false;
        }
        catch (IOException e) {
            LocalNotifier.notifier().info(e.getMessage());
            return false;
        }
        catch (XpathException e) {
            LocalNotifier.notifier().info("Warning: failed to evaluate the XPath expression " + this.expectedValue);
            return false;
        }
    }
}

