/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;

public class BuildSteps {
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String DESCRIPTION_FOR_TARBALL = "Building image tarball";
    private final String description;
    private final BuildConfiguration buildConfiguration;
    private final Caches.Initializer cachesInitializer;
    private final StepsRunnerConsumer stepsRunnerConsumer;

    public static BuildSteps forBuildToDockerRegistry(BuildConfiguration buildConfiguration, Caches.Initializer cachesInitializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_REGISTRY, buildConfiguration, cachesInitializer, stepsRunner -> stepsRunner.runRetrieveTargetRegistryCredentialsStep().runAuthenticatePushStep().runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runPushBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runPushContainerConfigurationStep().runPushApplicationLayersStep().runFinalizingPushStep().runPushImageStep().waitOnPushImageStep());
    }

    public static BuildSteps forBuildToDockerDaemon(BuildConfiguration buildConfiguration, Caches.Initializer cachesInitializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_DAEMON, buildConfiguration, cachesInitializer, stepsRunner -> stepsRunner.runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runLoadDockerStep().waitOnLoadDockerStep());
    }

    public static BuildSteps forBuildToTar(Path outputPath, BuildConfiguration buildConfiguration, Caches.Initializer cachesInitializer) {
        return new BuildSteps(DESCRIPTION_FOR_TARBALL, buildConfiguration, cachesInitializer, stepsRunner -> stepsRunner.runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep().runFinalizingBuildStep().runWriteTarFileStep(outputPath).waitOnWriteTarFileStep());
    }

    private BuildSteps(String description, BuildConfiguration buildConfiguration, Caches.Initializer cachesInitializer, StepsRunnerConsumer stepsRunnerConsumer) {
        this.description = description;
        this.buildConfiguration = buildConfiguration;
        this.cachesInitializer = cachesInitializer;
        this.stepsRunnerConsumer = stepsRunnerConsumer;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public void run() throws InterruptedException, ExecutionException, CacheMetadataCorruptedException, IOException, CacheDirectoryNotOwnedException, CacheDirectoryCreationException {
        this.buildConfiguration.getBuildLogger().lifecycle("");
        try (Timer ignored = new Timer(this.buildConfiguration.getBuildLogger(), this.description);
             Caches caches = this.cachesInitializer.init();){
            Cache baseImageLayersCache = caches.getBaseCache();
            Cache applicationLayersCache = caches.getApplicationCache();
            StepsRunner stepsRunner = new StepsRunner(this.buildConfiguration, baseImageLayersCache, applicationLayersCache);
            this.stepsRunnerConsumer.accept(stepsRunner);
            baseImageLayersCache.addCachedLayersToMetadata(stepsRunner.getCachedBaseImageLayers());
            applicationLayersCache.addCachedLayersWithMetadataToMetadata(stepsRunner.getCachedApplicationLayers());
        }
        if (this.buildConfiguration.getContainerConfiguration() != null) {
            this.buildConfiguration.getBuildLogger().lifecycle("");
            this.buildConfiguration.getBuildLogger().lifecycle("Container entrypoint set to " + this.buildConfiguration.getContainerConfiguration().getEntrypoint());
        }
    }

    @FunctionalInterface
    private static interface StepsRunnerConsumer {
        public void accept(StepsRunner var1) throws ExecutionException, InterruptedException;
    }
}

