/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.configuration.Port;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ContainerConfiguration {
    public static final Instant DEFAULT_CREATION_TIME = Instant.EPOCH;
    private final Instant creationTime;
    @Nullable
    private final ImmutableList<String> entrypoint;
    @Nullable
    private final ImmutableList<String> programArguments;
    @Nullable
    private final ImmutableMap<String, String> environmentMap;
    @Nullable
    private final ImmutableList<Port> exposedPorts;
    @Nullable
    private final ImmutableMap<String, String> labels;

    public static Builder builder() {
        return new Builder();
    }

    private ContainerConfiguration(Instant creationTime, @Nullable ImmutableList<String> entrypoint, @Nullable ImmutableList<String> programArguments, @Nullable ImmutableMap<String, String> environmentMap, @Nullable ImmutableList<Port> exposedPorts, @Nullable ImmutableMap<String, String> labels) {
        this.creationTime = creationTime;
        this.entrypoint = entrypoint;
        this.programArguments = programArguments;
        this.environmentMap = environmentMap;
        this.exposedPorts = exposedPorts;
        this.labels = labels;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Nullable
    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public ImmutableList<String> getProgramArguments() {
        return this.programArguments;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvironmentMap() {
        return this.environmentMap;
    }

    @Nullable
    public ImmutableList<Port> getExposedPorts() {
        return this.exposedPorts;
    }

    @Nullable
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    public static class Builder {
        private Instant creationTime = DEFAULT_CREATION_TIME;
        @Nullable
        private ImmutableList<String> entrypoint;
        @Nullable
        private ImmutableList<String> programArguments;
        @Nullable
        private ImmutableMap<String, String> environmentMap;
        @Nullable
        private ImmutableList<Port> exposedPorts;
        @Nullable
        private ImmutableMap<String, String> labels;

        public Builder setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setProgramArguments(@Nullable List<String> programArguments) {
            if (programArguments == null) {
                this.programArguments = null;
            } else {
                Preconditions.checkArgument((!programArguments.contains(null) ? 1 : 0) != 0);
                this.programArguments = ImmutableList.copyOf(programArguments);
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> environmentMap) {
            if (environmentMap == null) {
                this.environmentMap = null;
            } else {
                Preconditions.checkArgument((!Iterables.any(environmentMap.keySet(), Objects::isNull) ? 1 : 0) != 0);
                Preconditions.checkArgument((!Iterables.any(environmentMap.values(), Objects::isNull) ? 1 : 0) != 0);
                this.environmentMap = ImmutableMap.copyOf(environmentMap);
            }
            return this;
        }

        public Builder setExposedPorts(@Nullable List<Port> exposedPorts) {
            if (exposedPorts == null) {
                this.exposedPorts = null;
            } else {
                Preconditions.checkArgument((!exposedPorts.contains(null) ? 1 : 0) != 0);
                this.exposedPorts = ImmutableList.copyOf(exposedPorts);
            }
            return this;
        }

        public Builder setLabels(@Nullable Map<String, String> labels) {
            if (labels == null) {
                this.labels = null;
            } else {
                Preconditions.checkArgument((!Iterables.any(labels.keySet(), Objects::isNull) ? 1 : 0) != 0);
                Preconditions.checkArgument((!Iterables.any(labels.values(), Objects::isNull) ? 1 : 0) != 0);
                this.labels = ImmutableMap.copyOf(labels);
            }
            return this;
        }

        public Builder setEntrypoint(@Nullable List<String> entrypoint) {
            if (entrypoint == null) {
                this.entrypoint = null;
            } else {
                Preconditions.checkArgument((!entrypoint.contains(null) ? 1 : 0) != 0);
                this.entrypoint = ImmutableList.copyOf(entrypoint);
            }
            return this;
        }

        public ContainerConfiguration build() {
            return new ContainerConfiguration(this.creationTime, this.entrypoint, this.programArguments, this.environmentMap, this.exposedPorts, this.labels);
        }

        private Builder() {
        }
    }
}

