/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Constraint;
import com.google.common.collect.Constraints;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.NonSerializableForwardingCollection;
import com.google.common.collect.NonSerializableForwardingSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapConstraints {
    public static final MapConstraint<Object, Object> NOT_NULL = NotNullMapConstraint.INSTANCE;

    private MapConstraints() {
    }

    static MapConstraint<Object, Object> classConstraint(Class<?> keyType, Class<?> valueType) {
        return new ClassMapConstraint(keyType, valueType);
    }

    public static <K, V> Map<K, V> constrainedMap(Map<K, V> map, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedMap<K, V>(map, constraint);
    }

    public static <K, V> Multimap<K, V> constrainedMultimap(Multimap<K, V> multimap, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedMultimap<K, V>(multimap, constraint);
    }

    public static <K, V> ListMultimap<K, V> constrainedListMultimap(ListMultimap<K, V> multimap, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedListMultimap<K, V>(multimap, constraint);
    }

    public static <K, V> SetMultimap<K, V> constrainedSetMultimap(SetMultimap<K, V> multimap, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedSetMultimap<K, V>(multimap, constraint);
    }

    public static <K, V> SortedSetMultimap<K, V> constrainedSortedSetMultimap(SortedSetMultimap<K, V> multimap, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedSortedSetMultimap<K, V>(multimap, constraint);
    }

    private static <K, V> Map.Entry<K, V> constrainedEntry(Map.Entry<K, V> entry, final MapConstraint<? super K, ? super V> constraint) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(constraint);
        return new ForwardingMapEntry<K, V>(entry){

            @Override
            public V setValue(V value) {
                constraint.checkKeyValue(this.getKey(), value);
                return super.setValue(value);
            }
        };
    }

    private static <K, V> Map.Entry<K, Collection<V>> constrainedAsMapEntry(Map.Entry<K, Collection<V>> entry, final MapConstraint<? super K, ? super V> constraint) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkNotNull(constraint);
        return new ForwardingMapEntry<K, Collection<V>>(entry){

            @Override
            public Collection<V> getValue() {
                return Constraints.constrainedTypePreservingCollection((Collection)super.getValue(), new Constraint<V>(){

                    @Override
                    public void checkElement(V value) {
                        constraint.checkKeyValue(this.getKey(), value);
                    }
                });
            }
        };
    }

    private static <K, V> Set<Map.Entry<K, Collection<V>>> constrainedAsMapEntries(Set<Map.Entry<K, Collection<V>>> entries, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedAsMapEntries<K, V>(entries, constraint);
    }

    private static <K, V> Collection<Map.Entry<K, V>> constrainedEntries(Collection<Map.Entry<K, V>> entries, MapConstraint<? super K, ? super V> constraint) {
        if (entries instanceof Set) {
            return MapConstraints.constrainedEntrySet((Set)entries, constraint);
        }
        return new ConstrainedEntries<K, V>(entries, constraint);
    }

    private static <K, V> Set<Map.Entry<K, V>> constrainedEntrySet(Set<Map.Entry<K, V>> entries, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedEntrySet<K, V>(entries, constraint);
    }

    public static <K, V> BiMap<K, V> constrainedBiMap(BiMap<K, V> map, MapConstraint<? super K, ? super V> constraint) {
        return new ConstrainedBiMap<K, V>(map, null, constraint);
    }

    private static <K, V> Collection<V> checkValues(K key, Iterable<? extends V> values, MapConstraint<? super K, ? super V> constraint) {
        ArrayList copy = Lists.newArrayList(values);
        for (Object value : copy) {
            constraint.checkKeyValue(key, value);
        }
        return copy;
    }

    private static <K, V> Map<K, V> checkMap(Map<? extends K, ? extends V> map, MapConstraint<? super K, ? super V> constraint) {
        LinkedHashMap<K, V> copy = new LinkedHashMap<K, V>(map);
        for (Map.Entry entry : copy.entrySet()) {
            constraint.checkKeyValue(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    private static <K, V> Multimap<K, V> checkMultimap(Multimap<? extends K, ? extends V> map, MapConstraint<? super K, ? super V> constraint) {
        LinkedListMultimap<K, V> copy = new LinkedListMultimap<K, V>(map);
        for (Map.Entry entry : copy.entries()) {
            constraint.checkKeyValue(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedSortedSetMultimap<K, V>
    extends ConstrainedSetMultimap<K, V>
    implements SortedSetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        ConstrainedSortedSetMultimap(SortedSetMultimap<K, V> delegate, MapConstraint<? super K, ? super V> constraint) {
            super(delegate, constraint);
        }

        @Override
        public SortedSet<V> get(K key) {
            return (SortedSet)super.get((Object)key);
        }

        @Override
        public SortedSet<V> removeAll(Object key) {
            return (SortedSet)super.removeAll(key);
        }

        @Override
        public SortedSet<V> replaceValues(K key, Iterable<? extends V> values) {
            return (SortedSet)super.replaceValues((Object)key, (Iterable)values);
        }

        @Override
        public Comparator<? super V> valueComparator() {
            return ((SortedSetMultimap)this.delegate()).valueComparator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedSetMultimap<K, V>
    extends ConstrainedMultimap<K, V>
    implements SetMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        ConstrainedSetMultimap(SetMultimap<K, V> delegate, MapConstraint<? super K, ? super V> constraint) {
            super(delegate, constraint);
        }

        @Override
        public Set<V> get(K key) {
            return (Set)super.get(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entries() {
            return (Set)super.entries();
        }

        @Override
        public Set<V> removeAll(Object key) {
            return (Set)super.removeAll(key);
        }

        @Override
        public Set<V> replaceValues(K key, Iterable<? extends V> values) {
            return (Set)super.replaceValues(key, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedListMultimap<K, V>
    extends ConstrainedMultimap<K, V>
    implements ListMultimap<K, V> {
        private static final long serialVersionUID = 0L;

        ConstrainedListMultimap(ListMultimap<K, V> delegate, MapConstraint<? super K, ? super V> constraint) {
            super(delegate, constraint);
        }

        @Override
        public List<V> get(K key) {
            return (List)super.get(key);
        }

        @Override
        public List<V> removeAll(Object key) {
            return (List)super.removeAll(key);
        }

        @Override
        public List<V> replaceValues(K key, Iterable<? extends V> values) {
            return (List)super.replaceValues(key, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedAsMapEntries<K, V>
    extends NonSerializableForwardingSet<Map.Entry<K, Collection<V>>> {
        private final MapConstraint<? super K, ? super V> constraint;

        ConstrainedAsMapEntries(Set<Map.Entry<K, Collection<V>>> entries, MapConstraint<? super K, ? super V> constraint) {
            super(entries);
            this.constraint = constraint;
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new ForwardingIterator<Map.Entry<K, Collection<V>>>(super.iterator()){

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    return MapConstraints.constrainedAsMapEntry((Map.Entry)super.next(), ConstrainedAsMapEntries.this.constraint);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ForwardingSet.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ForwardingSet.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ForwardingSet.containsAllImpl(this, c);
        }

        @Override
        public boolean equals(Object o) {
            return ForwardingSet.equalsImpl(this, o);
        }

        @Override
        public int hashCode() {
            return ForwardingSet.hashCodeImpl(this);
        }

        @Override
        public boolean remove(Object o) {
            return Maps.removeEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return ForwardingSet.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return ForwardingSet.retainAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedEntrySet<K, V>
    extends ConstrainedEntries<K, V>
    implements Set<Map.Entry<K, V>> {
        ConstrainedEntrySet(Set<Map.Entry<K, V>> entries, MapConstraint<? super K, ? super V> constraint) {
            super(entries, constraint);
        }

        @Override
        public boolean equals(Object o) {
            return ForwardingSet.equalsImpl(this, o);
        }

        @Override
        public int hashCode() {
            return ForwardingSet.hashCodeImpl(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedEntries<K, V>
    extends NonSerializableForwardingCollection<Map.Entry<K, V>> {
        final MapConstraint<? super K, ? super V> constraint;

        ConstrainedEntries(Collection<Map.Entry<K, V>> entries, MapConstraint<? super K, ? super V> constraint) {
            super(entries);
            this.constraint = constraint;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ForwardingIterator<Map.Entry<K, V>>(super.iterator()){

                @Override
                public Map.Entry<K, V> next() {
                    return MapConstraints.constrainedEntry((Map.Entry)super.next(), ConstrainedEntries.this.constraint);
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ForwardingCollection.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ForwardingCollection.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return Maps.containsEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ForwardingCollection.containsAllImpl(this, c);
        }

        @Override
        public boolean remove(Object o) {
            return Maps.removeEntryImpl(this.delegate(), o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return ForwardingCollection.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return ForwardingCollection.retainAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedAsMapValues<K, V>
    extends NonSerializableForwardingCollection<Collection<V>> {
        final Set<Map.Entry<K, Collection<V>>> entrySet;

        ConstrainedAsMapValues(Collection<Collection<V>> delegate, Set<Map.Entry<K, Collection<V>>> entrySet) {
            super(delegate);
            this.entrySet = entrySet;
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            final Iterator<Map.Entry<K, Collection<V>>> iterator = this.entrySet.iterator();
            return new Iterator<Collection<V>>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Collection<V> next() {
                    return (Collection)((Map.Entry)iterator.next()).getValue();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ForwardingCollection.toArrayImpl(this);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ForwardingCollection.toArrayImpl(this, array);
        }

        @Override
        public boolean contains(Object o) {
            return ForwardingCollection.containsImpl(this, o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ForwardingCollection.containsAllImpl(this, c);
        }

        @Override
        public boolean remove(Object o) {
            return ForwardingCollection.removeImpl(this, o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return ForwardingCollection.removeAllImpl(this, c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return ForwardingCollection.retainAllImpl(this, c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedMultimap<K, V>
    extends ForwardingMultimap<K, V> {
        final MapConstraint<? super K, ? super V> constraint;
        volatile transient Collection<Map.Entry<K, V>> entries;
        volatile transient Map<K, Collection<V>> asMap;
        private static final long serialVersionUID = 1022236989881570422L;

        public ConstrainedMultimap(Multimap<K, V> delegate, MapConstraint<? super K, ? super V> constraint) {
            super(delegate);
            this.constraint = constraint;
        }

        @Override
        public Map<K, Collection<V>> asMap() {
            if (this.asMap == null) {
                this.asMap = new ForwardingMap<K, Collection<V>>(this.delegate().asMap()){
                    volatile Set<Map.Entry<K, Collection<V>>> entrySet;
                    volatile Collection<Collection<V>> values;

                    @Override
                    public Set<Map.Entry<K, Collection<V>>> entrySet() {
                        if (this.entrySet == null) {
                            this.entrySet = MapConstraints.constrainedAsMapEntries(super.entrySet(), ConstrainedMultimap.this.constraint);
                        }
                        return this.entrySet;
                    }

                    @Override
                    public Collection<V> get(Object key) {
                        Collection collection = ConstrainedMultimap.this.get(key);
                        return collection.isEmpty() ? null : collection;
                    }

                    @Override
                    public Collection<Collection<V>> values() {
                        if (this.values == null) {
                            this.values = new ConstrainedAsMapValues(this.delegate().values(), this.entrySet());
                        }
                        return this.values;
                    }

                    @Override
                    public boolean containsValue(Object o) {
                        return this.values().contains(o);
                    }
                };
            }
            return this.asMap;
        }

        @Override
        public Collection<Map.Entry<K, V>> entries() {
            if (this.entries == null) {
                this.entries = MapConstraints.constrainedEntries(super.entries(), this.constraint);
            }
            return this.entries;
        }

        @Override
        public Collection<V> get(final K key) {
            return Constraints.constrainedTypePreservingCollection(super.get(key), new Constraint<V>(){

                @Override
                public void checkElement(V value) {
                    ConstrainedMultimap.this.constraint.checkKeyValue(key, value);
                }
            });
        }

        @Override
        public boolean put(K key, V value) {
            this.constraint.checkKeyValue(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(K key, Iterable<? extends V> values) {
            super.putAll(key, MapConstraints.checkValues(key, values, this.constraint));
        }

        @Override
        public void putAll(Multimap<? extends K, ? extends V> multimap) {
            super.putAll(MapConstraints.checkMultimap(multimap, this.constraint));
        }

        @Override
        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            return super.replaceValues(key, MapConstraints.checkValues(key, values, this.constraint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InverseConstraint<K, V>
    implements MapConstraint<K, V>,
    Serializable {
        final MapConstraint<? super V, ? super K> constraint;
        private static final long serialVersionUID = 4461050635804577699L;

        public InverseConstraint(MapConstraint<? super V, ? super K> constraint) {
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public void checkKeyValue(K key, V value) {
            this.constraint.checkKeyValue(value, key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstrainedBiMap<K, V>
    extends ConstrainedMap<K, V>
    implements BiMap<K, V> {
        volatile transient BiMap<V, K> inverse;
        private static final long serialVersionUID = 0L;

        ConstrainedBiMap(BiMap<K, V> delegate, BiMap<V, K> inverse, MapConstraint<? super K, ? super V> constraint) {
            super(delegate, constraint);
            this.inverse = inverse;
        }

        @Override
        protected BiMap<K, V> delegate() {
            return (BiMap)super.delegate();
        }

        @Override
        public V forcePut(K key, V value) {
            this.constraint.checkKeyValue(key, value);
            return this.delegate().forcePut(key, value);
        }

        @Override
        public BiMap<V, K> inverse() {
            if (this.inverse == null) {
                this.inverse = new ConstrainedBiMap<K, V>(this.delegate().inverse(), this, new InverseConstraint(this.constraint));
            }
            return this.inverse;
        }

        @Override
        public Set<V> values() {
            return this.delegate().values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstrainedMap<K, V>
    extends ForwardingMap<K, V> {
        final MapConstraint<? super K, ? super V> constraint;
        private volatile transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 2187468218878274045L;

        ConstrainedMap(Map<K, V> delegate, MapConstraint<? super K, ? super V> constraint) {
            super(delegate);
            this.constraint = Preconditions.checkNotNull(constraint);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = MapConstraints.constrainedEntrySet(super.entrySet(), this.constraint);
            }
            return this.entrySet;
        }

        @Override
        public V put(K key, V value) {
            this.constraint.checkKeyValue(key, value);
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            super.putAll(MapConstraints.checkMap(map, this.constraint));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassMapConstraint
    implements MapConstraint<Object, Object>,
    Serializable {
        final Class<?> keyType;
        final Class<?> valueType;
        static final long serialVersionUID = 5170999662998754707L;

        ClassMapConstraint(Class<?> keyType, Class<?> valueType) {
            this.keyType = Preconditions.checkNotNull(keyType);
            this.valueType = Preconditions.checkNotNull(valueType);
        }

        @Override
        public void checkKeyValue(Object key, Object value) {
            this.keyType.cast(Preconditions.checkNotNull(key));
            this.valueType.cast(Preconditions.checkNotNull(value));
        }

        @Override
        public String toString() {
            return "key " + this.keyType + ", value " + this.valueType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NotNullMapConstraint implements MapConstraint<Object, Object>
    {
        INSTANCE;


        @Override
        public void checkKeyValue(Object key, Object value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
        }

        @Override
        public String toString() {
            return "Not null";
        }
    }
}

