/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheRecordStore;
import com.hazelcast.cache.impl.DefaultOperationProvider;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.event.CacheWanEventPublisher;
import com.hazelcast.cache.impl.operation.CacheReplicationOperation;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.partition.MigrationEndpoint;

public class CacheService
extends AbstractCacheService {
    @Override
    protected CachePartitionSegment newPartitionSegment(int partitionId) {
        return new CachePartitionSegment(this, partitionId);
    }

    @Override
    protected ICacheRecordStore createNewRecordStore(String name, int partitionId) {
        CacheRecordStore recordStore = new CacheRecordStore(name, partitionId, this.nodeEngine, this);
        recordStore.instrument(this.nodeEngine);
        return recordStore;
    }

    @Override
    protected CacheOperationProvider createOperationProvider(String nameWithPrefix, InMemoryFormat inMemoryFormat) {
        return new DefaultOperationProvider(nameWithPrefix);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        CachePartitionSegment segment = this.segments[event.getPartitionId()];
        CacheReplicationOperation op = new CacheReplicationOperation(segment, event.getReplicaIndex());
        return op.isEmpty() ? null : op;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        super.commitMigration(event);
        if (MigrationEndpoint.SOURCE == event.getMigrationEndpoint()) {
            this.getMetaDataGenerator().removeUuidAndSequence(event.getPartitionId());
        } else if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint() && event.getNewReplicaIndex() != 0) {
            this.getMetaDataGenerator().regenerateUuid(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        super.rollbackMigration(event);
        if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint()) {
            this.getMetaDataGenerator().removeUuidAndSequence(event.getPartitionId());
        }
    }

    private MetaDataGenerator getMetaDataGenerator() {
        return this.cacheEventHandler.getMetaDataGenerator();
    }

    public String toString() {
        return "CacheService[hz:impl:cacheService]";
    }

    @Override
    public boolean isWanReplicationEnabled(String cacheName) {
        return false;
    }

    @Override
    public CacheWanEventPublisher getCacheWanEventPublisher() {
        throw new UnsupportedOperationException("Wan replication is not supported");
    }
}

