/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryMadePublishableCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateCodec;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryPublisherCreateWithValueCodec;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClientQueryCacheEndToEndConstructor
extends AbstractQueryCacheEndToEndConstructor {
    public ClientQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        super(request);
    }

    @Override
    public void createPublisherAccumulator(AccumulatorInfo info) throws Exception {
        if (info.isIncludeValue()) {
            this.createPublishAccumulatorWithIncludeValue(info);
        } else {
            this.createPublishAccumulatorWithoutIncludeValue(info);
        }
        if (info.isPopulate()) {
            this.madePublishable(info.getMapName(), info.getCacheName());
            info.setPublishable(true);
        }
    }

    private void createPublishAccumulatorWithIncludeValue(AccumulatorInfo info) {
        Object data = this.context.getSerializationService().toData(info.getPredicate());
        ClientMessage request = ContinuousQueryPublisherCreateWithValueCodec.encodeRequest(info.getMapName(), info.getCacheName(), data, info.getBatchSize(), info.getBufferSize(), info.getDelaySeconds(), info.isPopulate(), info.isCoalesce());
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke(request);
        List<Map.Entry<Data, Data>> result = ContinuousQueryPublisherCreateWithValueCodec.decodeResponse((ClientMessage)response).response;
        this.populateWithValues(this.queryCache, result);
    }

    private void createPublishAccumulatorWithoutIncludeValue(AccumulatorInfo info) {
        Object data = this.context.getSerializationService().toData(info.getPredicate());
        ClientMessage request = ContinuousQueryPublisherCreateCodec.encodeRequest(info.getMapName(), info.getCacheName(), data, info.getBatchSize(), info.getBufferSize(), info.getDelaySeconds(), info.isPopulate(), info.isCoalesce());
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        ClientMessage response = (ClientMessage)invokerWrapper.invoke(request);
        List<Data> result = ContinuousQueryPublisherCreateCodec.decodeResponse((ClientMessage)response).response;
        this.populateWithoutValues(this.queryCache, result);
    }

    private void madePublishable(String mapName, String cacheName) throws Exception {
        ClientMessage request = ContinuousQueryMadePublishableCodec.encodeRequest(mapName, cacheName);
        this.context.getInvokerWrapper().invokeOnAllPartitions(request);
    }

    private void populateWithValues(InternalQueryCache queryCache, Collection<Map.Entry<Data, Data>> result) {
        for (Map.Entry<Data, Data> entry : result) {
            queryCache.setInternal(entry.getKey(), entry.getValue(), false, EntryEventType.ADDED);
        }
    }

    private void populateWithoutValues(InternalQueryCache queryCache, Collection<Data> result) {
        for (Data data : result) {
            queryCache.setInternal(data, null, false, EntryEventType.ADDED);
        }
    }
}

