/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    private final int minConsistentNearCacheSupportingServerVersion = BuildInfo.calculateVersion("3.8");
    private NearCache<Object, Object> nearCache;
    private ILogger logger;
    private volatile String invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        ClientContext context = this.getContext();
        this.logger = context.getLoggingService().getLogger(this.getClass());
        NearCacheConfig nearCacheConfig = context.getClientConfig().getNearCacheConfig(this.name);
        NearCacheManager nearCacheManager = context.getNearCacheManager();
        IMapDataStructureAdapter adapter = new IMapDataStructureAdapter(this);
        this.nearCache = nearCacheManager.getOrCreateNearCache(this.name, nearCacheConfig, adapter);
        if (nearCacheConfig.isInvalidateOnChange()) {
            this.registerInvalidationListener();
        }
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.getCachedValue(keyData, false);
        if (cached != NearCache.NOT_CACHED) {
            return true;
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected V getInternal(Data key) {
        Object value = this.getCachedValue(key, true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        long reservationId = this.nearCache.tryReserveForUpdate(key);
        if (reservationId == -1L) {
            value = super.getInternal(key);
        } else {
            try {
                value = super.getInternal(key);
                value = this.tryPublishReserved(key, value, reservationId);
            }
            catch (Throwable throwable) {
                this.invalidateNearCache(key);
                throw ExceptionUtil.rethrow(throwable);
            }
        }
        return (V)value;
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(final Data key) {
        ICompletableFuture future;
        Object value = this.getCachedValue(key, false);
        if (value != NearCache.NOT_CACHED) {
            return new CompletedFuture(this.getContext().getSerializationService(), value, this.getContext().getExecutionService().getUserExecutor());
        }
        final long reservationId = this.nearCache.tryReserveForUpdate(key);
        try {
            future = super.getAsyncInternal(key);
        }
        catch (Throwable t) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(t);
        }
        ((ClientDelegatingFuture)future).andThenInternal(new ExecutionCallback<Data>(){

            @Override
            public void onResponse(Data value) {
                NearCachedClientMapProxy.this.nearCache.tryPublishReserved(key, value, reservationId, false);
            }

            @Override
            public void onFailure(Throwable t) {
                NearCachedClientMapProxy.this.invalidateNearCache(key);
            }
        }, false);
        return future;
    }

    @Override
    protected MapRemoveCodec.ResponseParameters removeInternal(Data keyData) {
        MapRemoveCodec.ResponseParameters responseParameters = super.removeInternal(keyData);
        this.invalidateNearCache(keyData);
        return responseParameters;
    }

    @Override
    protected boolean removeInternal(Data keyData, Data valueData) {
        boolean removed = super.removeInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected void removeAllInternal(Predicate predicate) {
        super.removeAllInternal(predicate);
        this.nearCache.clear();
    }

    @Override
    protected void deleteInternal(Data keyData) {
        super.deleteInternal(keyData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected ICompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ICompletableFuture future = super.putAsyncInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected ICompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ICompletableFuture<Void> future = super.setAsyncInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected ICompletableFuture<V> removeAsyncInternal(Data keyData) {
        ICompletableFuture future = super.removeAsyncInternal(keyData);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        boolean removed = super.tryRemoveInternal(timeout, timeunit, keyData);
        this.invalidateNearCache(keyData);
        return removed;
    }

    @Override
    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        boolean putInternal = super.tryPutInternal(timeout, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return putInternal;
    }

    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.putTransientInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        Object previousValue = super.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
        return previousValue;
    }

    @Override
    protected boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        boolean replaceIfSame = super.replaceIfSameInternal(keyData, oldValueData, newValueData);
        this.invalidateNearCache(keyData);
        return replaceIfSame;
    }

    @Override
    protected V replaceInternal(Data keyData, Data valueData) {
        Object v = super.replaceInternal(keyData, valueData);
        this.invalidateNearCache(keyData);
        return v;
    }

    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        super.setInternal(ttl, timeunit, keyData, valueData);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected boolean evictInternal(Data keyData) {
        boolean evicted = super.evictInternal(keyData);
        this.invalidateNearCache(keyData);
        return evicted;
    }

    @Override
    public void evictAll() {
        super.evictAll();
        this.nearCache.clear();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        super.loadAll(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Collection<Data> dataKeys) {
        super.loadAllInternal(replaceExistingValues, dataKeys);
        this.invalidateNearCache(dataKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<MapGetAllCodec.ResponseParameters> getAllInternal(Map<Integer, List<Data>> pIdToKeyData, Map<K, V> result) {
        List<MapGetAllCodec.ResponseParameters> responses;
        HashMap<Data, Long> reservations = new HashMap<Data, Long>();
        try {
            Object value;
            Data key;
            for (Map.Entry<Integer, List<Data>> partitionKeyEntry : pIdToKeyData.entrySet()) {
                List<Data> keyList = partitionKeyEntry.getValue();
                Iterator<Data> iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    value = this.getCachedValue(key, true);
                    if (value == null || value == NearCache.NOT_CACHED) {
                        long reservationId = this.nearCache.tryReserveForUpdate(key);
                        if (reservationId == -1L) continue;
                        reservations.put(key, reservationId);
                        continue;
                    }
                    result.put(this.toObject(key), this.toObject(value));
                    iterator.remove();
                }
            }
            responses = super.getAllInternal(pIdToKeyData, result);
            for (MapGetAllCodec.ResponseParameters resultParameters : responses) {
                for (Map.Entry<Data, Data> entry : resultParameters.response) {
                    key = entry.getKey();
                    value = entry.getValue();
                    Long reservationId = (Long)reservations.get(key);
                    if (reservationId == null) continue;
                    Object cachedValue = this.tryPublishReserved(key, value, reservationId);
                    result.put(this.toObject(key), this.toObject(cachedValue));
                    reservations.remove(key);
                }
            }
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
        return responses;
    }

    private void releaseRemainingReservedKeys(Map<Data, Long> reservedKeys) {
        for (Map.Entry<Data, Long> entry : reservedKeys.entrySet()) {
            this.invalidateNearCache(entry.getKey());
        }
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStats localMapStats = super.getLocalMapStats();
        NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
        ((LocalMapStatsImpl)localMapStats).setNearCacheStats(nearCacheStats);
        return localMapStats;
    }

    @Override
    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        Object response = super.executeOnKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return response;
    }

    @Override
    public ICompletableFuture submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        ICompletableFuture future = super.submitToKeyInternal(keyData, entryProcessor);
        this.invalidateNearCache(keyData);
        return future;
    }

    @Override
    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        super.submitToKeyInternal(keyData, entryProcessor, callback);
        this.invalidateNearCache(keyData);
    }

    @Override
    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entrySet) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            this.invalidateNearCache(dataKey);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected void putAllInternal(Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        super.putAllInternal(entryMap);
        for (List<Map.Entry<Data, Data>> entries : entryMap.values()) {
            for (Map.Entry<Data, Data> entry : entries) {
                this.invalidateNearCache(entry.getKey());
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.nearCache.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onShutdown();
    }

    private Object tryPublishReserved(Data key, Object value, long reservationId) {
        assert (value != NearCache.NOT_CACHED);
        Object cachedValue = this.nearCache.tryPublishReserved(key, value, reservationId, true);
        return cachedValue != null ? cachedValue : value;
    }

    private Object getCachedValue(Data key, boolean deserializeValue) {
        Object value = this.nearCache.get(key);
        if (value == null) {
            return NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        return deserializeValue ? this.toObject(value) : value;
    }

    public NearCache<Object, Object> getNearCache() {
        return this.nearCache;
    }

    private void invalidateNearCache(Data key) {
        this.nearCache.remove(key);
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    public String addNearCacheInvalidationListener(EventHandler handler) {
        return this.registerListener(this.createNearCacheEntryListenerCodec(), handler);
    }

    private void registerInvalidationListener() {
        try {
            this.invalidationListenerId = this.addNearCacheInvalidationListener(new ConnectedServerVersionAwareNearCacheEventHandler());
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(this.getClass());
            logger.severe("-----------------\nNear Cache is not initialized!\n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                if (NearCachedClientMapProxy.this.supportsRepairableNearCache()) {
                    return MapAddNearCacheInvalidationListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
                }
                return MapAddNearCacheEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                if (NearCachedClientMapProxy.this.supportsRepairableNearCache()) {
                    return MapAddNearCacheInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
                return MapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.getContext().getRepairingTask("hz:impl:mapService").deregisterHandler(this.name);
        this.deregisterListener(invalidationListenerId);
    }

    public ClientContext getClientContext() {
        return this.getContext();
    }

    private int getConnectedServerVersion() {
        ClientContext clientContext = this.getClientContext();
        ClientClusterService clusterService = clientContext.getClusterService();
        Address ownerConnectionAddress = clusterService.getOwnerConnectionAddress();
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        Connection connection = connectionManager.getConnection(ownerConnectionAddress);
        if (connection == null) {
            this.logger.warning(String.format("No owner connection is available, near cached cache %s will be started in legacy mode", this.name));
            return -1;
        }
        return ((ClientConnection)connection).getConnectedServerVersion();
    }

    private boolean supportsRepairableNearCache() {
        return this.getConnectedServerVersion() >= this.minConsistentNearCacheSupportingServerVersion;
    }

    private final class Pre38NearCacheEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private Pre38NearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            if (key == null) {
                NearCachedClientMapProxy.this.nearCache.clear();
            } else {
                NearCachedClientMapProxy.this.nearCache.remove(key);
            }
        }

        @Override
        public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            for (Data key : keys) {
                NearCachedClientMapProxy.this.nearCache.remove(key);
            }
        }
    }

    private final class RepairableNearCacheEventHandler
    extends MapAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private RepairableNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
            this.getRepairingTask().deregisterHandler(NearCachedClientMapProxy.this.name);
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
            this.repairingHandler = this.getRepairingTask().registerAndGetHandler(NearCachedClientMapProxy.this.name, NearCachedClientMapProxy.this.nearCache);
        }

        @Override
        public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }

        private RepairingTask getRepairingTask() {
            ClientContext clientContext = NearCachedClientMapProxy.this.getClientContext();
            return clientContext.getRepairingTask("hz:impl:mapService");
        }
    }

    private final class ConnectedServerVersionAwareNearCacheEventHandler
    implements EventHandler<ClientMessage> {
        private volatile boolean supportsRepairableNearCache;
        private final RepairableNearCacheEventHandler repairingEventHandler;
        private final Pre38NearCacheEventHandler pre38EventHandler;

        private ConnectedServerVersionAwareNearCacheEventHandler() {
            this.repairingEventHandler = new RepairableNearCacheEventHandler();
            this.pre38EventHandler = new Pre38NearCacheEventHandler();
        }

        @Override
        public void beforeListenerRegister() {
            this.repairingEventHandler.beforeListenerRegister();
            this.pre38EventHandler.beforeListenerRegister();
        }

        @Override
        public void onListenerRegister() {
            this.supportsRepairableNearCache = NearCachedClientMapProxy.this.supportsRepairableNearCache();
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.onListenerRegister();
            } else {
                this.pre38EventHandler.onListenerRegister();
            }
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.handle(clientMessage);
            } else {
                this.pre38EventHandler.handle(clientMessage);
            }
        }
    }
}

